/*
 * Decompiled with CFR 0.152.
 */
package software.sandc.springframework.security.jwt.consumer;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SigningKeyResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;
import software.sandc.springframework.security.jwt.JWTRequestResponseHandler;
import software.sandc.springframework.security.jwt.consumer.JWTAuthorityConnector;
import software.sandc.springframework.security.jwt.impl.DefaultSigningKeyResolver;
import software.sandc.springframework.security.jwt.model.JWTAuthentication;
import software.sandc.springframework.security.jwt.model.JWTContext;
import software.sandc.springframework.security.jwt.model.TokenContainer;
import software.sandc.springframework.security.jwt.model.exception.ExpiredTokenException;
import software.sandc.springframework.security.jwt.model.exception.InvalidTokenException;
import software.sandc.springframework.security.jwt.model.parameter.DisableXSRFParameter;
import software.sandc.springframework.security.jwt.model.parameter.IgnoreExpiryParameter;
import software.sandc.springframework.security.jwt.model.parameter.Parameters;
import software.sandc.springframework.security.jwt.util.BooleanUtils;

public class JWTConsumer
implements InitializingBean {
    protected static final Integer TEN_YEARS_IN_SECONDS = 315360000;
    public static final String SPRING_SECURITY_JWT_XSRF_PARAMETER_NAME = "xsrf-token";
    public static final String SPRING_SECURITY_JWT_SESSION_ID_PARAMETER_NAME = "jti";
    public static final String SPRING_SECURITY_JWT_AUTHORITIES_PARAMETER_NAME = "authorities";
    protected String authoritiesParameterName = "authorities";
    protected String sessionIdParameterName = "jti";
    protected String xsrfParameterName = "xsrf-token";
    protected JWTAuthorityConnector jwtAuthorityConnector;
    protected SigningKeyResolver signingKeyResolver;
    protected JWTRequestResponseHandler jwtRequestResponseHandler;

    public JWTConsumer() {
    }

    public JWTConsumer(JWTAuthorityConnector jwtAuthorityConnector) {
        this.jwtAuthorityConnector = jwtAuthorityConnector;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.jwtAuthorityConnector, (String)"jwtAuthorityConnector must be specified");
        if (this.jwtRequestResponseHandler == null) {
            this.jwtRequestResponseHandler = new JWTRequestResponseHandler();
        }
        if (this.signingKeyResolver == null) {
            this.signingKeyResolver = new DefaultSigningKeyResolver(this.jwtAuthorityConnector);
        }
    }

    public JWTContext authenticateJWTRequest(HttpServletRequest request, HttpServletResponse response) {
        JWTContext jwtContext = null;
        TokenContainer tokenContainer = this.jwtRequestResponseHandler.getTokenFromRequest(request);
        if (tokenContainer != null) {
            try {
                Parameters parameters = this.jwtRequestResponseHandler.getParametersFromRequest(request);
                jwtContext = this.validate(tokenContainer, parameters);
            }
            catch (ExpiredTokenException e) {
                jwtContext = this.jwtAuthorityConnector.requestRenew(request);
            }
            this.handleJWTContext(request, response, jwtContext);
        }
        return jwtContext;
    }

    public JWTContext validate(TokenContainer tokenContainer, Parameters parameters) throws InvalidTokenException, ExpiredTokenException {
        if (tokenContainer == null) {
            throw new InvalidTokenException("Token container is empty");
        }
        JwtParser jwtParser = Jwts.parser().setSigningKeyResolver(this.signingKeyResolver);
        if (parameters != null && BooleanUtils.isTrue((Boolean)parameters.getValueOf(IgnoreExpiryParameter.class)).booleanValue()) {
            jwtParser = jwtParser.setAllowedClockSkewSeconds((long)TEN_YEARS_IN_SECONDS.intValue());
        }
        String jwtToken = tokenContainer.getJwtToken();
        String jwtMode = this.getJWTModeFromParameters(parameters);
        try {
            Jws jws = jwtParser.parseClaimsJws(jwtToken);
            Claims claims = (Claims)jws.getBody();
            String xsrfToken = tokenContainer.getXsrfToken();
            this.validateXSRF(claims, xsrfToken);
            String principal = this.extractPrincipal(claims);
            String sessionId = this.extractSessionId(claims);
            Collection<GrantedAuthority> authorities = this.getAuthorities(claims);
            JWTContext jwtContext = this.createJWTContext(principal, sessionId, xsrfToken, authorities, jwtMode, jwtToken);
            return jwtContext;
        }
        catch (ExpiredJwtException e) {
            throw new ExpiredTokenException("JWT Token is expired.");
        }
        catch (JwtException e) {
            throw new InvalidTokenException("JWT Token is invalid.", e);
        }
    }

    public void setSigningKeyResolver(SigningKeyResolver signingKeyResolver) {
        this.signingKeyResolver = signingKeyResolver;
    }

    public void setJWTAuthorityConnector(JWTAuthorityConnector jwtAuthorityConnector) {
        this.jwtAuthorityConnector = jwtAuthorityConnector;
    }

    public void setJwtRequestResponseHandler(JWTRequestResponseHandler jwtRequestResponseHandler) {
        this.jwtRequestResponseHandler = jwtRequestResponseHandler;
    }

    public JWTRequestResponseHandler getJwtRequestResponseHandler() {
        return this.jwtRequestResponseHandler;
    }

    public void setAuthoritiesParameterName(String authoritiesParameterName) {
        this.authoritiesParameterName = authoritiesParameterName;
    }

    public void setXsrfParameterName(String xsrfParameterName) {
        this.xsrfParameterName = xsrfParameterName;
    }

    public void setSessionIdParameterName(String sessionIdParameterName) {
        this.sessionIdParameterName = sessionIdParameterName;
    }

    protected void handleJWTContext(HttpServletRequest request, HttpServletResponse response, JWTContext jwtContext) {
        if (jwtContext != null && jwtContext.isAuthenticated()) {
            JWTAuthentication authentication = jwtContext.getAuthentication();
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
            this.jwtRequestResponseHandler.putTokenToResponse(request, response, jwtContext.getTokenContainer());
        }
    }

    protected void validateXSRF(Claims claims, String xsrfToken) {
        String xsrfTokenFromClaim = (String)claims.get(this.xsrfParameterName, String.class);
        if (xsrfTokenFromClaim != null && !xsrfTokenFromClaim.equals(xsrfToken)) {
            throw new InsufficientAuthenticationException("XSRF Token is not valid.");
        }
    }

    protected String extractPrincipal(Claims claims) {
        String principal = claims.getSubject();
        if (principal == null || principal.isEmpty()) {
            throw new InvalidTokenException("A valid token must provide a non-empty principal value.");
        }
        return principal;
    }

    protected String extractSessionId(Claims claims) {
        String sessionId = (String)claims.get(this.sessionIdParameterName, String.class);
        return sessionId;
    }

    protected Collection<GrantedAuthority> getAuthorities(Claims claims) {
        String authoritiesAsString = (String)claims.get(this.authoritiesParameterName, String.class);
        if (authoritiesAsString == null || authoritiesAsString.isEmpty()) {
            return null;
        }
        List<String> authoritiesStringList = Arrays.asList(authoritiesAsString.split(","));
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        for (String authority : authoritiesStringList) {
            authorities.add((GrantedAuthority)new SimpleGrantedAuthority(authority));
        }
        return authorities;
    }

    protected JWTContext createJWTContext(String principal, String sessionId, String xsrfToken, Collection<? extends GrantedAuthority> authorities, String jwtMode, String jwtToken) {
        TokenContainer tokenContainer = new TokenContainer(jwtMode, jwtToken, xsrfToken);
        JWTAuthentication authentication = new JWTAuthentication(principal, sessionId, authorities);
        JWTContext jwtContext = new JWTContext(authentication, tokenContainer);
        return jwtContext;
    }

    protected String getJWTModeFromParameters(Parameters parameters) {
        if (parameters != null && BooleanUtils.isTrue((Boolean)parameters.getValueOf(DisableXSRFParameter.class)).booleanValue()) {
            return "app";
        }
        return "web";
    }
}

