/*
 * Decompiled with CFR 0.152.
 */
package software.sandc.springframework.security.jwt.impl;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SigningKeyResolverAdapter;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.impl.TextCodec;
import java.security.Key;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import software.sandc.springframework.security.jwt.consumer.KeyProvider;
import software.sandc.springframework.security.jwt.model.KeyType;
import software.sandc.springframework.security.jwt.util.RSAUtils;

public class DefaultSigningKeyResolver
extends SigningKeyResolverAdapter
implements InitializingBean {
    private KeyProvider keyProvider;

    public DefaultSigningKeyResolver(KeyProvider keyProvider) {
        this.keyProvider = keyProvider;
    }

    public Key resolveSigningKey(JwsHeader header, Claims claims) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.forName((String)header.getAlgorithm());
        if (signatureAlgorithm.isRsa()) {
            String signingKey = this.getSigningKey(header);
            return RSAUtils.toPublicKey(signingKey);
        }
        if (signatureAlgorithm.isHmac()) {
            byte[] keyBytes = this.resolveSigningKeyBytes(header, claims);
            return new SecretKeySpec(keyBytes, signatureAlgorithm.getJcaName());
        }
        throw new UnsupportedJwtException("Not supported signature algorithm " + signatureAlgorithm.getValue());
    }

    public Key resolveSigningKey(JwsHeader header, String plaintext) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.forName((String)header.getAlgorithm());
        if (signatureAlgorithm.isRsa()) {
            String signingKey = this.getSigningKey(header);
            return RSAUtils.toPublicKey(signingKey);
        }
        if (signatureAlgorithm.isHmac()) {
            byte[] keyBytes = this.resolveSigningKeyBytes(header, plaintext);
            return new SecretKeySpec(keyBytes, signatureAlgorithm.getJcaName());
        }
        throw new UnsupportedJwtException("Not supported signature algorithm " + signatureAlgorithm.getValue());
    }

    public byte[] resolveSigningKeyBytes(JwsHeader header, Claims claims) {
        return this.getBinarySigningKey(header);
    }

    public byte[] resolveSigningKeyBytes(JwsHeader header, String payload) {
        return this.getBinarySigningKey(header);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.keyProvider, (String)"keyProvider must be specified");
    }

    private byte[] getBinarySigningKey(JwsHeader header) {
        String key = this.getSigningKey(header);
        return TextCodec.BASE64.decode(key);
    }

    private String getSigningKey(JwsHeader header) {
        String key;
        String keyId = header.getKeyId();
        if (keyId == null || keyId.isEmpty()) {
            throw new JwtException("JWT header does not contain key id. ");
        }
        KeyType keyType = this.keyProvider.getKeyType(keyId);
        if (KeyType.ASYMMETRIC.equals((Object)keyType)) {
            key = this.keyProvider.getPublicKey(keyId);
        } else if (KeyType.SYMMETRIC.equals((Object)keyType)) {
            key = this.keyProvider.getPrivateKey(keyId);
        } else {
            throw new JwtException("Unknown or empty key type detected.");
        }
        if (key == null) {
            throw new JwtException("No key can be found for given key JWT header.");
        }
        return key;
    }
}

