/*
 * Decompiled with CFR 0.152.
 */
package software.sandc.springframework.security.jwt.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import software.sandc.springframework.security.jwt.model.JWTAuthentication;

public class JWTAuthenticationSerializer
extends JsonDeserializer<JWTAuthentication> {
    public JWTAuthentication deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode authoritiesNodes;
        JsonNode sessionIdNode;
        JsonNode principalNode;
        boolean authenticated = false;
        String principal = null;
        String sessionId = null;
        List authorities = null;
        ObjectCodec oc = jsonParser.getCodec();
        JsonNode node = (JsonNode)oc.readTree(jsonParser);
        JsonNode authenticatedNode = node.get("authenticated");
        if (authenticatedNode != null) {
            authenticated = authenticatedNode.booleanValue();
        }
        if ((principalNode = node.get("principal")) != null) {
            principal = principalNode.asText();
        }
        if ((sessionIdNode = node.get("sessionId")) != null) {
            sessionId = sessionIdNode.asText();
        }
        if ((authoritiesNodes = node.get("authorities")) != null) {
            ArrayList<SimpleGrantedAuthority> tempAuthorities = new ArrayList<SimpleGrantedAuthority>(authoritiesNodes.size());
            Iterator authoritiesNodesIterator = authoritiesNodes.elements();
            while (authoritiesNodesIterator.hasNext()) {
                JsonNode next = (JsonNode)authoritiesNodesIterator.next();
                JsonNode authority = next.get("authority");
                SimpleGrantedAuthority simpleGrantedAuthority = new SimpleGrantedAuthority(authority.asText());
                tempAuthorities.add(simpleGrantedAuthority);
            }
            authorities = Collections.unmodifiableList(tempAuthorities);
        }
        JWTAuthentication jwtAuthentication = new JWTAuthentication(principal, sessionId, authorities);
        jwtAuthentication.setAuthenticated(authenticated);
        return jwtAuthentication;
    }
}

