/*
 * Decompiled with CFR 0.152.
 */
package software.sandc.springframework.security.jwt.model;

import software.sandc.springframework.security.jwt.model.JWTAuthentication;
import software.sandc.springframework.security.jwt.model.TokenContainer;

public class JWTContext {
    private JWTAuthentication authentication;
    private TokenContainer tokenContainer;

    public JWTContext() {
    }

    public JWTContext(JWTAuthentication authentication, TokenContainer tokenContainer) {
        this.authentication = authentication;
        this.tokenContainer = tokenContainer;
    }

    public JWTAuthentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(JWTAuthentication authentication) {
        this.authentication = authentication;
    }

    public TokenContainer getTokenContainer() {
        return this.tokenContainer;
    }

    public void setTokenContainer(TokenContainer tokenContainer) {
        this.tokenContainer = tokenContainer;
    }

    public boolean isAuthenticated() {
        return this.authentication != null && this.authentication.isAuthenticated();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.authentication == null ? 0 : this.authentication.hashCode());
        result = 31 * result + (this.tokenContainer == null ? 0 : this.tokenContainer.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JWTContext other = (JWTContext)obj;
        if (this.authentication == null ? other.authentication != null : !this.authentication.equals((Object)other.authentication)) {
            return false;
        }
        return !(this.tokenContainer == null ? other.tokenContainer != null : !this.tokenContainer.equals(other.tokenContainer));
    }

    public String toString() {
        return "JWTContext [authentication=" + (Object)((Object)this.authentication) + ", tokenContainer=" + this.tokenContainer + "]";
    }
}

