/*
 * Decompiled with CFR 0.152.
 */
package software.sandc.springframework.security.jwt.model;

import java.io.Serializable;

public class TokenContainer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String jwtMode;
    private String jwtToken;
    private String xsrfToken;

    private TokenContainer() {
    }

    public TokenContainer(String jwtMode, String jwtToken) {
        this.jwtMode = jwtMode;
        this.jwtToken = jwtToken;
    }

    public TokenContainer(String jwtMode, String jwtToken, String xsrfToken) {
        this.jwtMode = jwtMode;
        this.jwtToken = jwtToken;
        this.xsrfToken = xsrfToken;
    }

    public String getJwtMode() {
        return this.jwtMode;
    }

    public String getJwtToken() {
        return this.jwtToken;
    }

    public String getXsrfToken() {
        return this.xsrfToken;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.jwtMode == null ? 0 : this.jwtMode.hashCode());
        result = 31 * result + (this.jwtToken == null ? 0 : this.jwtToken.hashCode());
        result = 31 * result + (this.xsrfToken == null ? 0 : this.xsrfToken.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TokenContainer other = (TokenContainer)obj;
        if (this.jwtMode == null ? other.jwtMode != null : !this.jwtMode.equals(other.jwtMode)) {
            return false;
        }
        if (this.jwtToken == null ? other.jwtToken != null : !this.jwtToken.equals(other.jwtToken)) {
            return false;
        }
        return !(this.xsrfToken == null ? other.xsrfToken != null : !this.xsrfToken.equals(other.xsrfToken));
    }

    public String toString() {
        return "TokenContainer [jwtMode=" + this.jwtMode + ", jwtToken=" + this.jwtToken + ", xsrfToken=" + this.xsrfToken + "]";
    }
}

