/*
 * Decompiled with CFR 0.152.
 */
package software.sham.sftp;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.virtualfs.VirtualFileSystemFactory;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.command.ScpCommandFactory;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystemFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.sham.ssh.MockSshServer;

public class MockSftpServer
extends MockSshServer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Path baseDirectory;

    public MockSftpServer(int port) throws IOException {
        this(port, false);
    }

    private MockSftpServer(int port, boolean enableShell) throws IOException {
        super(port, false);
        this.initSftp();
        if (enableShell) {
            this.enableShell();
        }
        this.start();
    }

    private void initSftp() {
        this.sshServer.setCommandFactory((CommandFactory)new ScpCommandFactory());
        this.sshServer.setSubsystemFactories(Arrays.asList(new SftpSubsystemFactory()));
    }

    public Path getBaseDirectory() {
        return this.baseDirectory;
    }

    @Override
    public void start() throws IOException {
        this.baseDirectory = Files.createTempDirectory("sftproot", new FileAttribute[0]);
        this.sshServer.setFileSystemFactory((FileSystemFactory)new VirtualFileSystemFactory(this.baseDirectory.toAbsolutePath().toString()));
        super.start();
    }

    @Override
    public void stop() throws IOException {
        super.stop();
        FileUtils.deleteQuietly((File)this.baseDirectory.toFile());
    }

    public static MockSftpServer createWithShell(int port) throws IOException {
        return new MockSftpServer(port, true);
    }
}

