/*
 * Decompiled with CFR 0.152.
 */
package software.sham.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.sham.ssh.ResponderDispatcher;

public class MockSshShell
implements Command {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private ExitCallback callback;
    private final ResponderDispatcher dispatcher = new ResponderDispatcher();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private MockShellEventLoop eventLoop = new MockShellEventLoop(this);
    private Future<Void> eventLoopFuture;

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    public void start(Environment env) throws IOException {
        this.logger.debug("Starting mock SSH shell");
        this.eventLoopFuture = this.executor.submit(this.eventLoop);
    }

    public void destroy() {
        this.closeSession();
        this.executor.shutdown();
    }

    public void closeSession() {
        this.eventLoop.stop();
    }

    protected List<String> readInput() throws IOException {
        StringBuffer sb = new StringBuffer();
        Charset charset = StandardCharsets.UTF_8;
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        int len = this.in.available();
        while (len > 0) {
            if (len > 1024) {
                len = 1024;
            }
            int lenRead = this.in.read(buffer.array(), 0, len);
            CharBuffer cb = charset.decode(buffer);
            sb.append(cb, 0, lenRead);
            this.logger.trace("Read {} characters from {} bytes", (Object)cb.length(), (Object)lenRead);
            len = this.in.available();
        }
        return Arrays.asList(sb.toString().split("\\r?\\n"));
    }

    protected void writeError(Exception e) throws IOException {
        Writer writer = Channels.newWriter(Channels.newChannel(this.err), StandardCharsets.UTF_8.name());
        writer.write(e.toString());
        writer.flush();
        writer.close();
    }

    public void sendResponse(String output) {
        try {
            this.out.write(output.getBytes());
            this.logger.trace("Wrote output {}", (Object)output);
            this.out.flush();
        }
        catch (IOException e) {
            this.logger.error("Error sending response to client", (Throwable)e);
        }
    }

    public ResponderDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public class MockShellEventLoop
    implements Runnable {
        private boolean stopped = false;
        private final MockSshShell shell;

        public MockShellEventLoop(MockSshShell shell) {
            this.shell = shell;
        }

        public void stop() {
            if (!this.stopped) {
                this.stopped = true;
                MockSshShell.this.logger.info("Stopped Mock SSH shell event loop");
            }
        }

        @Override
        public void run() {
            while (!this.stopped) {
                MockSshShell.this.logger.trace("Polling input...");
                try {
                    List<String> input = this.shell.readInput();
                    MockSshShell.this.logger.trace("Returned from reading input");
                    for (String line : input) {
                        MockSshShell.this.logger.debug("SSH server received input [{}]", (Object)line.toString());
                        MockSshShell.this.dispatcher.find(line).respond(this.shell);
                    }
                    Thread.sleep(100L);
                }
                catch (IOException e) {
                    try {
                        this.shell.writeError(e);
                    }
                    catch (IOException e2) {
                        System.err.println(e2.toString());
                    }
                }
                catch (InterruptedException e) {
                    MockSshShell.this.logger.debug("Interrupted event loop thread: " + e.getMessage());
                }
            }
            MockSshShell.this.logger.debug("Event loop completed");
            MockSshShell.this.callback.onExit(0);
        }
    }
}

