/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.chartjs.model.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public abstract class Dataset<T extends Dataset<T, O>, O> {
    protected final List<Object> data = new ArrayList<Object>();

    public List<Object> getData() {
        return Collections.unmodifiableList(this.data);
    }

    public <X> List<X> getData(Class<X> filterClazz) {
        return this.data.stream().filter(filterClazz::isInstance).map(filterClazz::cast).collect(Collectors.toUnmodifiableList());
    }

    public T setDataUnchecked(Collection<?> data) {
        this.clearData();
        if (data != null) {
            this.data.addAll(data);
        }
        return this.self();
    }

    public T setData(Collection<O> data) {
        return this.setDataUnchecked(data);
    }

    public T setDataUnchecked(Object ... data) {
        return this.setDataUnchecked(Arrays.asList(data));
    }

    public T setData(O ... data) {
        return this.setData((Collection<O>)Arrays.asList(data));
    }

    public T clearData() {
        this.data.clear();
        return this.self();
    }

    public T addDataUnchecked(Object data) {
        this.data.add(data);
        return this.self();
    }

    public T addData(O data) {
        return this.addDataUnchecked(data);
    }

    public T self() {
        return (T)this;
    }
}

