/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.maven.music;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.ReentrantLock;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class MP3OggPlayer {
    private final ReentrantLock playingLock = new ReentrantLock();
    private boolean externalStop;

    public boolean play(InputStream is, float volumeDb) {
        this.playingLock.lock();
        try {
            boolean bl;
            block20: {
                AudioInputStream in = AudioSystem.getAudioInputStream(is);
                try {
                    AudioFormat outFormat = this.getOutFormat(in.getFormat());
                    DataLine.Info info = new DataLine.Info(SourceDataLine.class, outFormat);
                    try (SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);){
                        if (line != null) {
                            line.open(outFormat);
                            line.start();
                            Control control = line.getControl(FloatControl.Type.MASTER_GAIN);
                            if (control instanceof FloatControl) {
                                FloatControl floatControl = (FloatControl)control;
                                floatControl.setValue(Math.max(Math.min(floatControl.getMaximum(), volumeDb), floatControl.getMinimum()));
                            }
                            this.stream(AudioSystem.getAudioInputStream(outFormat, in), line);
                            line.drain();
                            line.stop();
                        }
                    }
                    bl = this.externalStop;
                    if (in == null) break block20;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
                        throw new IllegalStateException(e);
                    }
                }
                in.close();
            }
            return bl;
        }
        finally {
            this.externalStop = false;
            this.playingLock.unlock();
        }
    }

    private AudioFormat getOutFormat(AudioFormat inFormat) {
        int ch = inFormat.getChannels();
        float rate = inFormat.getSampleRate();
        return new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, rate, 16, ch, ch * 2, rate, false);
    }

    private void stream(AudioInputStream in, SourceDataLine line) throws IOException {
        byte[] buffer = new byte[4096];
        int n = 0;
        while (n != -1 && !this.externalStop) {
            line.write(buffer, 0, n);
            n = in.read(buffer, 0, buffer.length);
        }
    }

    public void stopAndWaitUntilFinished() {
        this.stop();
        this.waitUntilPlayingFinished();
    }

    protected void stop() {
        this.externalStop = true;
    }

    protected void waitUntilPlayingFinished() {
        if (this.playingLock.isLocked()) {
            this.playingLock.lock();
            this.playingLock.unlock();
        }
    }
}

