/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.maven.music;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import software.xdev.maven.music.MP3OggPlayer;
import software.xdev.maven.music.MusicSource;
import software.xdev.maven.music.PlayerInstance;

@Mojo(name="music", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class MusicMojo
extends AbstractMojo {
    protected static final AtomicInteger THREAD_COUNTER = new AtomicInteger(0);
    @Parameter(property="music.skip")
    protected boolean skip;
    @Parameter
    protected List<MusicSource> sources = new ArrayList<MusicSource>(List.of(MusicSource.fromClassPath("/default/Local_Forecast_-_Elevator.ogg")));
    @Parameter
    protected boolean shuffle;
    @Parameter
    protected boolean repeat = true;
    @Parameter
    protected boolean background = true;
    @Parameter
    protected float defaultVolumeDB = -20.0f;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping");
            return;
        }
        if (this.sources.isEmpty()) {
            this.getLog().info((CharSequence)"No sources");
            return;
        }
        if (!this.background) {
            this.repeat = false;
        }
        Thread thread = new Thread(this::runOnThread, "Maven-Music-Player-" + THREAD_COUNTER.getAndIncrement());
        thread.setDaemon(true);
        thread.start();
        if (!this.background) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private void runOnThread() {
        try {
            ArrayList<MusicSource> sourcesWorkingCopy = new ArrayList<MusicSource>(this.sources);
            if (this.shuffle) {
                Collections.shuffle(sourcesWorkingCopy);
            }
            MP3OggPlayer player = PlayerInstance.get().map(p -> {
                this.getLog().debug((CharSequence)"Stopping music");
                p.stopAndWaitUntilFinished();
                return p;
            }).orElseGet(() -> PlayerInstance.set(new MP3OggPlayer()));
            boolean wasStopped = false;
            block7: do {
                for (MusicSource source : sourcesWorkingCopy) {
                    this.getLog().info((CharSequence)("[\ud83c\udfb5] Now playing: " + String.valueOf(source)));
                    InputStream is = source.openInputStream();
                    try {
                        if (!player.play(is, Optional.ofNullable(source.getVolumeDB()).orElse(Float.valueOf(this.defaultVolumeDB)).floatValue())) continue;
                        wasStopped = true;
                        continue block7;
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
            } while (this.repeat && !wasStopped);
        }
        catch (Exception ex) {
            this.getLog().warn((CharSequence)"Failed to play stream", (Throwable)ex);
        }
    }
}

