/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.maven.music;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;

public class MusicSource {
    private String uri;
    private String classpath;
    private String file;
    private Float volumeDB;

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public Float getVolumeDB() {
        return this.volumeDB;
    }

    public void setVolumeDB(Float volumeDB) {
        this.volumeDB = volumeDB;
    }

    public InputStream openInputStream() {
        if (this.getClasspath() != null) {
            return this.getClass().getResourceAsStream(this.getClasspath());
        }
        if (this.getFile() != null) {
            File f = new File(this.getFile());
            try {
                return new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                throw new UncheckedIOException("Failed to find " + f.getAbsolutePath(), e);
            }
        }
        try {
            return URI.create(this.getUri()).toURL().openStream();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static MusicSource fromClassPath(String classpath) {
        MusicSource source = new MusicSource();
        source.setClasspath(classpath);
        return source;
    }

    public String toString() {
        if (this.getClasspath() != null) {
            return "[classpath]:" + this.getClasspath();
        }
        if (this.getFile() != null) {
            return "[file]:" + this.getFile();
        }
        return this.getUri();
    }
}

