/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.maven.music;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import software.xdev.maven.music.PlayerManager;
import software.xdev.maven.music.sources.WrappedMusicSource;
import software.xdev.maven.music.sources.mp3ogg.ClassPathMusicSource;

@Mojo(name="music", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class MusicMojo
extends AbstractMojo {
    protected static final AtomicInteger THREAD_COUNTER = new AtomicInteger(0);
    @Parameter(property="music.skip")
    protected boolean skip;
    @Parameter
    protected List<WrappedMusicSource> sources = new ArrayList<WrappedMusicSource>(List.of(new WrappedMusicSource(new ClassPathMusicSource("/default/Local_Forecast_-_Elevator.ogg"))));
    @Parameter
    protected boolean shuffle;
    @Parameter
    protected boolean repeat = true;
    @Parameter
    protected boolean background = true;
    @Parameter
    protected float defaultVolumeDB = -20.0f;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping");
            return;
        }
        if (this.sources.isEmpty()) {
            this.getLog().info((CharSequence)"No sources");
            return;
        }
        if (!this.background) {
            this.repeat = false;
        }
        Thread thread = new Thread(this::runOnThread, "Maven-Music-Player-" + THREAD_COUNTER.getAndIncrement());
        thread.setDaemon(true);
        thread.start();
        if (!this.background) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private void runOnThread() {
        try {
            ArrayList<WrappedMusicSource> sourcesWorkingCopy = new ArrayList<WrappedMusicSource>(this.sources);
            if (this.shuffle) {
                Collections.shuffle(sourcesWorkingCopy);
            }
            PlayerManager.instance().stopActivePlayer();
            boolean wasStopped = false;
            block2: do {
                for (WrappedMusicSource source : sourcesWorkingCopy) {
                    if (!PlayerManager.instance().play(source.getMusicSource(), this.defaultVolumeDB, this.getLog())) continue;
                    wasStopped = true;
                    continue block2;
                }
            } while (this.repeat && !wasStopped);
        }
        catch (Exception ex) {
            this.getLog().warn((CharSequence)"Failed to play stream", (Throwable)ex);
        }
    }
}

