/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.maven.music;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.maven.plugin.logging.Log;
import software.xdev.maven.music.player.Player;
import software.xdev.maven.music.sources.MusicSource;

public final class PlayerManager {
    private static final PlayerManager INSTANCE = new PlayerManager();
    private final List<Player> availablePlayers;
    private final Map<Class<? extends MusicSource>, Player<?>> sourcePlayers = new HashMap();
    private Player<?> lastActivePlayer;
    private final ReentrantLock playLock = new ReentrantLock();

    public static PlayerManager instance() {
        return INSTANCE;
    }

    private PlayerManager() {
        this.availablePlayers = ServiceLoader.load(Player.class).stream().map(ServiceLoader.Provider::get).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean play(MusicSource source, float defaultVolumeDB, Log log) {
        this.playLock.lock();
        try {
            Player player;
            this.lastActivePlayer = player = this.sourcePlayers.computeIfAbsent(source.getClass(), clazz -> this.availablePlayers.stream().filter(p -> p.supportedMusicSourceType().isAssignableFrom((Class<?>)clazz)).findFirst().orElseThrow());
            log.info((CharSequence)("[\ud83c\udfb5] Now playing: " + String.valueOf(source)));
            boolean bl = player.play(source, defaultVolumeDB, log);
            return bl;
        }
        finally {
            this.playLock.unlock();
        }
    }

    public synchronized void stopActivePlayer() {
        if (this.lastActivePlayer != null) {
            this.lastActivePlayer.stop();
            if (this.playLock.isLocked()) {
                this.playLock.lock();
                this.playLock.unlock();
            }
            this.lastActivePlayer = null;
        }
    }
}

