/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.maven.music.player;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.util.Locale;
import org.apache.maven.plugin.logging.Log;
import software.xdev.maven.music.player.Player;
import software.xdev.maven.music.sources.spotify.SpotifyMusicSource;

public class SpotifyPlayer
implements Player<SpotifyMusicSource> {
    private static final String OS_NAME_LOWER = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH);

    @Override
    public Class<SpotifyMusicSource> supportedMusicSourceType() {
        return SpotifyMusicSource.class;
    }

    @Override
    public boolean play(SpotifyMusicSource source, float defaultVolumeDB, Log log) {
        ProcessBuilder pb;
        String uri = source.getResolvedUri();
        if (OS_NAME_LOWER.contains("win")) {
            pb = new ProcessBuilder("cmd", "/c", "start", "\"\"", uri);
        } else if (OS_NAME_LOWER.contains("mac")) {
            pb = new ProcessBuilder("osascript", "-e", String.format("tell application \"Spotify\" to play track \"%s\"", uri));
        } else if (OS_NAME_LOWER.contains("nux") || OS_NAME_LOWER.contains("nix")) {
            pb = new ProcessBuilder("dbus-send", "--print-reply", "--dest=org.mpris.MediaPlayer2.spotify", "/org/mpris/MediaPlayer2", "org.mpris.MediaPlayer2.Player.OpenUri", "string:" + uri);
        } else {
            return false;
        }
        try {
            Process process = pb.start();
            String stdOut = SpotifyPlayer.consumeStream(process.getInputStream());
            String stdErr = SpotifyPlayer.consumeStream(process.getErrorStream());
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                Object errorMessage = String.format("Failed to play Spotify URI '%s'. Exit code: %d.", uri, exitCode);
                if (!stdErr.isBlank()) {
                    errorMessage = (String)errorMessage + " Error: " + stdErr;
                }
                if (!stdOut.isBlank()) {
                    errorMessage = (String)errorMessage + " Output: " + stdOut;
                }
                log.warn((CharSequence)errorMessage);
            }
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Got interrupted", e);
        }
        return false;
    }

    @Override
    public void stop() {
    }

    static String consumeStream(InputStream stream) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append(System.lineSeparator());
            }
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
        return sb.toString();
    }
}

