/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.maven.music.sources;

import java.util.Objects;
import java.util.stream.Stream;
import software.xdev.maven.music.sources.MusicSource;
import software.xdev.maven.music.sources.mp3ogg.ClassPathMusicSource;
import software.xdev.maven.music.sources.mp3ogg.FileMusicSource;
import software.xdev.maven.music.sources.mp3ogg.URIMusicSource;
import software.xdev.maven.music.sources.spotify.SpotifyMusicSource;

public class WrappedMusicSource
implements MusicSource {
    private ClassPathMusicSource classpath;
    private URIMusicSource uri;
    private FileMusicSource file;
    private SpotifyMusicSource spotify;

    public WrappedMusicSource() {
    }

    public WrappedMusicSource(ClassPathMusicSource classpath) {
        this.classpath = classpath;
    }

    public MusicSource getMusicSource() {
        return Stream.of(this.classpath, this.uri, this.file, this.spotify).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalArgumentException("No source defined"));
    }

    public ClassPathMusicSource getClasspath() {
        return this.classpath;
    }

    public void setClasspath(ClassPathMusicSource classpath) {
        this.classpath = classpath;
    }

    public URIMusicSource getUri() {
        return this.uri;
    }

    public void setUri(URIMusicSource uri) {
        this.uri = uri;
    }

    public FileMusicSource getFile() {
        return this.file;
    }

    public void setFile(FileMusicSource file) {
        this.file = file;
    }
}

