/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.maven.music.sources.spotify;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import software.xdev.maven.music.sources.MusicSource;

public class SpotifyMusicSource
implements MusicSource {
    private static final Pattern SPOTIFY_URI_PATTERN = Pattern.compile("^spotify:(track|playlist|album|artist|episode|show):([a-zA-Z0-9]+)$");
    private static final Pattern SPOTIFY_URL_PATTERN = Pattern.compile("^https:\\/\\/open\\.spotify\\.com\\/(track|playlist|album|artist|episode|show)\\/([a-zA-Z0-9]+)(?:\\?.*)?$");
    private String uri;
    private String resolvedUri;

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
        this.resolvedUri = SpotifyMusicSource.resolveUri(uri);
    }

    protected static String resolveUri(String input) {
        String trimmed = input.trim();
        if (SPOTIFY_URI_PATTERN.matcher(trimmed).matches()) {
            return trimmed;
        }
        Matcher urlMatcher = SPOTIFY_URL_PATTERN.matcher(trimmed);
        if (urlMatcher.matches()) {
            return "spotify:" + urlMatcher.group(1) + ":" + urlMatcher.group(2);
        }
        throw new IllegalArgumentException("Invalid Spotify URI or URL format: " + input + "\nPlease use a 'spotify:<type>:<id>' URI (e.g., spotify:track:xxxx) or 'https://open.spotify.com/<type>/<id>' URL (e.g., https://open.spotify.com/track/xxxx)");
    }

    public String getResolvedUri() {
        return this.resolvedUri;
    }

    public void setResolvedUri(String resolvedUri) {
        this.resolvedUri = resolvedUri;
    }

    public String toString() {
        return "[spotify]: uri=" + this.uri + ", resolvedUri=" + this.resolvedUri;
    }
}

