/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.vaadin.breadcrumbs;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Stream;

@CssImport(value="./styles/breadcrumb.css")
public class Breadcrumbs
extends HorizontalLayout {
    protected static final String DELIMITER_URL = "/";
    protected static final String BREADCRUMB_CLASS = "breadcrumb";
    protected static final String BREADCRUMBS_CONTAINER_CLASS = "breadcrumbs-container";
    protected String homeBreadcrumbName = "Home";
    protected BiFunction<List<String>, String, String> breadcrumbNameResolver = (parts, part) -> part;

    public Breadcrumbs(String path) {
        this();
        this.updatePath(path);
    }

    public Breadcrumbs() {
        this.addClassName(BREADCRUMBS_CONTAINER_CLASS);
    }

    public Breadcrumbs withHomeBreadcrumbName(String name) {
        this.homeBreadcrumbName = Objects.requireNonNull(name);
        return this;
    }

    public Breadcrumbs withBreadcrumbNameResolver(BiFunction<List<String>, String, String> breadcrumbNameResolver) {
        this.breadcrumbNameResolver = Objects.requireNonNull(breadcrumbNameResolver);
        return this;
    }

    public void updatePath(String path) {
        this.updateView(Stream.concat(Stream.of(new Breadcrumb(this.homeBreadcrumbName, DELIMITER_URL)), this.buildBreadcrumbs(Arrays.asList(path.split(DELIMITER_URL))).stream()).toList());
    }

    protected List<Breadcrumb> buildBreadcrumbs(List<String> parts) {
        ArrayList currentPaths = new ArrayList();
        return parts.stream().filter(s -> !s.isEmpty()).map(part -> {
            currentPaths.add(part);
            return new Breadcrumb(this.breadcrumbNameResolver.apply(Collections.unmodifiableList(currentPaths), (String)part), String.join((CharSequence)DELIMITER_URL, currentPaths));
        }).toList();
    }

    protected void updateView(List<Breadcrumb> breadcrumbs) {
        this.removeAll();
        HorizontalLayout layout = new HorizontalLayout();
        layout.setSpacing(false);
        for (Breadcrumb breadcrumb : breadcrumbs) {
            Anchor anchor = new Anchor(breadcrumb.url(), breadcrumb.label());
            anchor.addClassName(BREADCRUMB_CLASS);
            layout.add(new Component[]{anchor});
        }
        this.add(new Component[]{layout});
    }

    public void updateFromCurrentPath() {
        this.updatePath(UI.getCurrent().getActiveViewLocation().getPath());
    }

    protected record Breadcrumb(String label, String url) {
    }
}

