/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.vaadin.daterange_picker.business;

import java.time.LocalDate;
import java.time.Period;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import software.xdev.vaadin.daterange_picker.business.DateRange;
import software.xdev.vaadin.daterange_picker.business.DateRangeResult;

public abstract class AbstractDateRange<SELF extends AbstractDateRange<SELF>>
implements DateRange {
    private String key;
    private Optional<Period> optMovePeriod = Optional.empty();
    private String defaultDesc;
    private Function<LocalDate, Optional<DateRangeResult>> calcForFunc;
    private BiFunction<LocalDate, Integer, Optional<DateRangeResult>> moveFunc = (date, count) -> {
        if (this.optMovePeriod.isEmpty()) {
            return Optional.empty();
        }
        return this.calcForFunc.apply(count != 0 ? date.plus(this.optMovePeriod.get().multipliedBy((int)count)) : date);
    };
    private boolean movable = true;
    private boolean calcable = true;
    private boolean setable = true;

    public SELF self() {
        return (SELF)this;
    }

    public SELF withKey(String key) {
        this.key = key;
        return this.self();
    }

    public SELF withMovePeriod(Period period) {
        this.optMovePeriod = Optional.ofNullable(period);
        return this.self();
    }

    public SELF withDefaultDesc(String defaultDesc) {
        this.defaultDesc = defaultDesc;
        return this.self();
    }

    public SELF withCalcForFunc(Function<LocalDate, DateRangeResult> calcForFunc) {
        return this.withOptCalcForFunc(date -> Optional.ofNullable((DateRangeResult)calcForFunc.apply((LocalDate)date)));
    }

    public SELF withOptCalcForFunc(Function<LocalDate, Optional<DateRangeResult>> calcForFunc) {
        this.calcForFunc = calcForFunc;
        return this.self();
    }

    public SELF withMoveFunc(BiFunction<LocalDate, Integer, Optional<DateRangeResult>> moveFunc) {
        this.moveFunc = moveFunc;
        return this.self();
    }

    public SELF withMovable(boolean movable) {
        this.movable = movable;
        return this.self();
    }

    public SELF withCalcable(boolean calcable) {
        this.calcable = calcable;
        return this.self();
    }

    public SELF withSettable(boolean settable) {
        this.setable = settable;
        return this.self();
    }

    public SELF from(AbstractDateRange<?> dateRange) {
        this.key = dateRange.getKey();
        this.optMovePeriod = dateRange.getOptMovePeriod();
        this.defaultDesc = dateRange.getDefaultDescription();
        this.calcForFunc = dateRange.getCalcForFunc();
        this.moveFunc = dateRange.getMoveFunc();
        this.movable = dateRange.isMovable();
        this.calcable = dateRange.isCalcable();
        this.setable = dateRange.isSettable();
        return this.self();
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Optional<Period> getOptMovePeriod() {
        return this.optMovePeriod;
    }

    @Override
    public String getDefaultDescription() {
        return this.defaultDesc;
    }

    @Override
    public boolean isMovable() {
        return this.movable && this.isCalcable();
    }

    @Override
    public boolean isCalcable() {
        return this.calcable;
    }

    @Override
    public boolean isSettable() {
        return this.setable;
    }

    public Function<LocalDate, Optional<DateRangeResult>> getCalcForFunc() {
        return this.calcForFunc;
    }

    public BiFunction<LocalDate, Integer, Optional<DateRangeResult>> getMoveFunc() {
        return this.moveFunc;
    }

    @Override
    public Optional<DateRangeResult> calcFor(LocalDate date) {
        if (!this.isCalcable()) {
            return Optional.empty();
        }
        return this.calcForFunc.apply(date);
    }

    @Override
    public Optional<DateRangeResult> moveDateRange(LocalDate date, int dif) {
        if (!this.isMovable()) {
            return Optional.empty();
        }
        return this.moveFunc.apply(date, dif);
    }
}

