/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.vaadin.daterange_picker.ui;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.binder.HasItems;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import software.xdev.vaadin.daterange_picker.business.DateRange;
import software.xdev.vaadin.daterange_picker.business.DateRangeActions;
import software.xdev.vaadin.daterange_picker.business.DateRangeModel;
import software.xdev.vaadin.daterange_picker.ui.DateRangePickerOverlay;
import software.xdev.vaadin.daterange_picker.ui.DateRangeValueChangeEvent;

@CssImport(value="./styles/dateRangePicker.css")
public class DateRangePicker<D extends DateRange>
extends Composite<VerticalLayout>
implements FlexComponent,
HasItems<D>,
DateRangeActions<D, DateRangePicker<D>>,
HasValue<DateRangeValueChangeEvent<D>, DateRangeModel<D>> {
    public static final Locale DEFAULT_LOCALE = Locale.US;
    protected static AtomicInteger nextID = new AtomicInteger(0);
    protected boolean expanded;
    protected DateRangeModel<D> model;
    protected boolean useClientSideLocale = true;
    protected Optional<Locale> formatLocale = Optional.empty();
    protected ItemLabelGenerator<D> dateRangeLocalizerFunction = DateRange::getDefaultDescription;
    protected Optional<DatePicker.DatePickerI18n> datePickerI18n = Optional.empty();
    protected boolean closeOnOutsideClick = true;
    protected boolean allowRangeLimitExceeding = true;
    protected final Button btnOverview = new Button();
    protected final Div overlayContainer = new Div();
    protected final DateRangePickerOverlay<D> overlay = new DateRangePickerOverlay(this);

    public DateRangePicker(DateRangeModel<D> initialModel) {
        this(initialModel, new ArrayList());
    }

    public DateRangePicker(DateRangeModel<D> initialModel, D[] items) {
        this(initialModel, new ArrayList<D>(Arrays.asList(items)));
    }

    public DateRangePicker(DateRangeModel<D> initialModel, Collection<D> items) {
        this.model = Objects.requireNonNull(initialModel);
        this.overlay.setItems(items);
        this.initUI();
        this.registerListeners();
    }

    public DateRangePicker(Supplier<DateRangeModel<D>> initialModelSupplier) {
        this(initialModelSupplier.get());
    }

    public DateRangePicker(Supplier<DateRangeModel<D>> initialModelSupplier, D[] items) {
        this(initialModelSupplier.get(), (DateRange[])items);
    }

    public DateRangePicker(Supplier<DateRangeModel<D>> initialModelSupplier, Collection<D> items) {
        this(initialModelSupplier.get(), items);
    }

    public DateRangePicker<D> withCloseOnOutsideClick(boolean closeOnOutsideClick) {
        this.closeOnOutsideClick = closeOnOutsideClick;
        return this;
    }

    public boolean isCloseOnOutsideClick() {
        return this.closeOnOutsideClick;
    }

    public DateRangePicker<D> withDatePickerI18n(DatePicker.DatePickerI18n datePickerI18n) {
        this.datePickerI18n = Optional.ofNullable(datePickerI18n);
        return this;
    }

    public Optional<DatePicker.DatePickerI18n> getDatePickerI18n() {
        return this.datePickerI18n;
    }

    public DateRangePicker<D> withFormatLocale(Locale locale) {
        this.useClientSideLocale = locale == null;
        this.formatLocale = Optional.ofNullable(locale);
        return this;
    }

    public Locale getFormatLocale() {
        return this.formatLocale.orElse(DEFAULT_LOCALE);
    }

    public DateRangePicker<D> withDateRangeLocalizerFunction(ItemLabelGenerator<D> dateRangeLocalizerFunction) {
        this.dateRangeLocalizerFunction = dateRangeLocalizerFunction;
        return this;
    }

    public ItemLabelGenerator<D> getDateRangeLocalizerFunction() {
        return this.dateRangeLocalizerFunction;
    }

    public DateRangePicker<D> withStartLabel(String label) {
        this.setStartLabel(label);
        return this;
    }

    public DateRangePicker<D> withEndLabel(String label) {
        this.setEndLabel(label);
        return this;
    }

    public DateRangePicker<D> withDateRangeOptionsLabel(String label) {
        this.setDateRangeOptionsLabel(label);
        return this;
    }

    public DateRangePicker<D> withAllowRangeLimitExceeding(boolean allowRangeLimitExceeding) {
        this.setAllowRangeLimitExceeding(allowRangeLimitExceeding);
        return this;
    }

    protected void initUI() {
        this.setId("DateRangePickerID" + nextID.incrementAndGet());
        this.btnOverview.addClassNames(new String[]{"date-range-picker-button", "date-range-picker-clickable"});
        this.btnOverview.setMinWidth("20em");
        this.btnOverview.setWidthFull();
        this.btnOverview.setDisableOnClick(true);
        this.overlay.addClassName("date-range-picker-overlay-layout");
        this.overlay.setWidthFull();
        this.overlay.setHeight("auto");
        this.overlayContainer.setWidthFull();
        this.overlayContainer.addClassName("date-range-picker-overlay-base");
        this.overlayContainer.add(new Component[]{this.overlay});
        ((VerticalLayout)this.getContent()).setSpacing(false);
        ((VerticalLayout)this.getContent()).setPadding(false);
        this.setSizeUndefined();
        this.add(new Component[]{this.btnOverview, this.overlayContainer});
        this.setExpanded(false);
    }

    protected void registerListeners() {
        this.btnOverview.addClickListener((ComponentEventListener & Serializable)ev -> {
            this.toggle();
            ((Button)ev.getSource()).setEnabled(true);
        });
        this.overlay.addValueChangeListener((ComponentEventListener<DateRangePickerOverlay.DateRangeOverlayValueChangeEvent>)(ComponentEventListener & Serializable)ev -> {
            this.model = ((DateRangePickerOverlay)ev.getSource()).getModel();
            this.updateFromModel(false);
            this.fireEvent((ComponentEvent)new DateRangeValueChangeEvent(this, ev.getOldValue(), ev.isFromClient()));
        });
    }

    protected void onAttach(AttachEvent attachEvent) {
        this.setLocaleFromClient();
        this.updateFromModel(true);
        this.addClickOutsideListener();
    }

    protected void setLocaleFromClient() {
        if (this.useClientSideLocale) {
            this.formatLocale = Optional.ofNullable(VaadinService.getCurrentRequest().getLocale());
        }
    }

    protected void addClickOutsideListener() {
        if (!this.isCloseOnOutsideClick()) {
            return;
        }
        String funcName = "outsideClickFunc" + (String)this.getId().orElseThrow();
        String jsCommand = String.join((CharSequence)"\r\n", "var " + funcName + " = function(event) {", "  var spEl = document.getElementById('" + (String)this.getId().orElseThrow() + "');", "  if (!spEl) {", "    document.removeEventListener('click'," + funcName + ");", "    return;", "  }", "  let parent = event.target;", "  while(parent) {", "    let tagName = parent.tagName.toLowerCase();", "    if((tagName.includes('vaadin') && tagName.includes('overlay')) || parent.id == 'overlay') {", "      return;", "    }", "    parent = parent.parentElement;", "  }", "  var isClickInside = spEl.contains(event.target);", "  if (!isClickInside) {", "    spEl.$server.clickOutsideOccurred();", "  }", "}; ", "document.body.addEventListener('click'," + funcName + ");");
        ((VerticalLayout)this.getContent()).getElement().executeJs(jsCommand, new Serializable[0]);
    }

    @ClientCallable
    protected void clickOutsideOccurred() {
        if (!this.isCloseOnOutsideClick()) {
            return;
        }
        if (this.isExpanded()) {
            this.setExpanded(false);
        }
    }

    protected void updateFromModel(boolean updateOverlay) {
        if (updateOverlay) {
            this.tryFixInvalidModel();
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT).withLocale(this.getFormatLocale());
        this.btnOverview.setText(this.model.getStart().format(formatter) + (String)(this.model.getStart().equals(this.model.getEnd()) ? "" : " - " + this.model.getEnd().format(formatter)));
        if (updateOverlay) {
            this.overlay.setModel(this.model);
        }
    }

    protected void tryFixInvalidModel() {
        this.model.getDateRange().calcFor(this.model.getStart()).ifPresent(result -> {
            this.model.setStart(result.getStart());
            this.model.setEnd(result.getEnd());
        });
    }

    protected void toggle() {
        this.setExpanded(!this.isExpanded());
    }

    protected synchronized void setExpanded(boolean expanded) {
        this.expanded = expanded;
        this.btnOverview.setIcon((Component)(expanded ? VaadinIcon.CARET_DOWN.create() : VaadinIcon.CARET_UP.create()));
        this.overlay.setVisible(expanded);
    }

    public synchronized boolean isExpanded() {
        return this.expanded;
    }

    public DateRangePickerOverlay<D> getOverlay() {
        return this.overlay;
    }

    public Button getBtnOverview() {
        return this.btnOverview;
    }

    public Div getOverlayContainer() {
        return this.overlayContainer;
    }

    public void setStartLabel(String label) {
        Objects.requireNonNull(label);
        this.getOverlay().getDpStart().setLabel(label);
    }

    public void setEndLabel(String label) {
        Objects.requireNonNull(label);
        this.getOverlay().getDpEnd().setLabel(label);
    }

    public void setDateRangeOptionsLabel(String label) {
        Objects.requireNonNull(label);
        this.getOverlay().getCbDateRange().setLabel(label);
    }

    public void setAllowRangeLimitExceeding(boolean allowRangeLimitExceeding) {
        this.allowRangeLimitExceeding = allowRangeLimitExceeding;
    }

    public boolean isAllowRangeLimitExceeding() {
        return this.allowRangeLimitExceeding;
    }

    public void setDateRangeForToday(D range) {
        range.calcFor(LocalDate.now()).ifPresent(result -> this.setValue(new DateRangeModel<DateRange>(result.getStart(), result.getEnd(), (DateRange)range)));
    }

    public void setItems(Collection<D> items) {
        this.overlay.setItems(items);
    }

    @Override
    public LocalDate getStart() {
        return this.model.getStart();
    }

    @Override
    public DateRangePicker<D> setStart(LocalDate start) {
        this.model.setStart(start);
        this.updateFromModel(true);
        return this;
    }

    @Override
    public LocalDate getEnd() {
        return this.model.getEnd();
    }

    @Override
    public DateRangePicker<D> setEnd(LocalDate end) {
        this.model.setEnd(end);
        this.updateFromModel(true);
        return this;
    }

    @Override
    public D getDateRange() {
        return this.model.getDateRange();
    }

    @Override
    public DateRangePicker<D> setDateRange(D dateRange) {
        this.model.setDateRange((DateRange)dateRange);
        this.updateFromModel(true);
        return this;
    }

    public void setValue(DateRangeModel<D> value) {
        Objects.requireNonNull(value);
        this.model = value;
        this.updateFromModel(true);
    }

    public DateRangeModel<D> getValue() {
        return this.model;
    }

    public Registration addValueChangeListener(HasValue.ValueChangeListener<? super DateRangeValueChangeEvent<D>> listener) {
        ComponentEventListener & Serializable componentListener = (ComponentEventListener & Serializable)event -> listener.valueChanged((HasValue.ValueChangeEvent)((DateRangeValueChangeEvent)event));
        return ComponentUtil.addListener((Component)this, DateRangeValueChangeEvent.class, (ComponentEventListener)componentListener);
    }

    public DateRangeModel<D> getEmptyValue() {
        return null;
    }

    public boolean isEmpty() {
        return false;
    }

    public void clear() {
        throw new UnsupportedOperationException("The calling of clear is not supported because DateRangePicker always has a value");
    }

    public void setReadOnly(boolean readOnly) {
        this.getOverlay().setReadOnly(readOnly);
    }

    public boolean isReadOnly() {
        return this.getOverlay().isReadOnly();
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
    }

    public boolean isRequiredIndicatorVisible() {
        return false;
    }
}

