/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.vaadin.daterange_picker.ui;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.binder.HasItems;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import software.xdev.vaadin.daterange_picker.business.DateRange;
import software.xdev.vaadin.daterange_picker.business.DateRangeModel;
import software.xdev.vaadin.daterange_picker.business.DateRangeResult;
import software.xdev.vaadin.daterange_picker.ui.DateRangePicker;

@CssImport(value="./styles/dateRangePicker.css")
public class DateRangePickerOverlay<D extends DateRange>
extends Composite<VerticalLayout>
implements HasItems<D>,
FlexComponent {
    protected boolean readOnly = false;
    protected DateRangePicker<D> dateRangePicker;
    protected DateRangeModel<D> currentModel;
    protected final Button btnBackwardRange = new Button((Component)VaadinIcon.ANGLE_LEFT.create());
    protected ComboBox<D> cbDateRange = new ComboBox("Period");
    protected final Button btnForwardRange = new Button((Component)VaadinIcon.ANGLE_RIGHT.create());
    protected DatePicker dpStart = new DatePicker("Start");
    protected DatePicker dpEnd = new DatePicker("End");

    public DateRangePickerOverlay(DateRangePicker<D> dateRangePicker) {
        this.dateRangePicker = Objects.requireNonNull(dateRangePicker);
        this.currentModel = this.dateRangePicker.getValue();
        this.initUI();
        this.registerListeners();
    }

    protected void initUI() {
        this.btnBackwardRange.addClassNames(new String[]{"flex-child-contentsize", "date-range-picker-clickable"});
        this.cbDateRange.addClassName("flex-child-autogrow");
        this.setTextFieldDefaultWidthFlexConform((HasStyle)this.cbDateRange);
        this.btnForwardRange.addClassNames(new String[]{"flex-child-contentsize", "date-range-picker-clickable"});
        HorizontalLayout hlRange = new HorizontalLayout();
        hlRange.addClassNames(new String[]{"flex-child-autogrow", "flex-container"});
        hlRange.setAlignItems(FlexComponent.Alignment.BASELINE);
        hlRange.setJustifyContentMode(FlexComponent.JustifyContentMode.BETWEEN);
        hlRange.setMargin(false);
        hlRange.setSpacing(true);
        hlRange.setPadding(false);
        hlRange.add(new Component[]{this.btnBackwardRange, this.cbDateRange, this.btnForwardRange});
        this.initDatePicker(this.dpStart);
        this.initDatePicker(this.dpEnd);
        HorizontalLayout hlDatepickers = new HorizontalLayout();
        hlDatepickers.addClassNames(new String[]{"flex-child-autogrow", "flex-container"});
        hlDatepickers.setMargin(false);
        hlDatepickers.setSpacing(true);
        hlDatepickers.setPadding(false);
        hlDatepickers.add(new Component[]{this.dpStart, this.dpEnd});
        this.addClassName("flex-container");
        this.add(new Component[]{hlRange, hlDatepickers});
        ((VerticalLayout)this.getContent()).setPadding(true);
    }

    protected void initDatePicker(DatePicker dp) {
        this.setTextFieldDefaultWidthFlexConform((HasStyle)dp);
        dp.addClassName("flex-child-autogrow");
        dp.setWeekNumbersVisible(true);
    }

    protected void onAttach(AttachEvent attachEvent) {
        this.cbDateRange.setItemLabelGenerator(this.dateRangePicker.getDateRangeLocalizerFunction());
        this.dateRangePicker.getDatePickerI18n().ifPresent(i18n -> {
            this.dpStart.setI18n(i18n);
            this.dpEnd.setI18n(i18n);
        });
    }

    protected void setTextFieldDefaultWidthFlexConform(HasStyle component) {
        component.getStyle().set("--vaadin-field-default-width", "auto");
    }

    protected void registerListeners() {
        this.cbDateRange.addValueChangeListener(this::onComboBoxDateRangeValueChanged);
        this.btnBackwardRange.addClickListener((ComponentEventListener & Serializable)ev -> this.moveRange(-1));
        this.btnForwardRange.addClickListener((ComponentEventListener & Serializable)ev -> this.moveRange(1));
        this.dpStart.addValueChangeListener(this::onDatePickerValueChanged);
        this.dpEnd.addValueChangeListener(this::onDatePickerValueChanged);
    }

    protected void onComboBoxDateRangeValueChanged(AbstractField.ComponentValueChangeEvent<ComboBox<D>, D> ev) {
        if (!ev.isFromClient()) {
            return;
        }
        this.onValueChange(model -> model.getDateRange().calcFor(model.getStart()));
    }

    protected void onDatePickerValueChanged(AbstractField.ComponentValueChangeEvent<DatePicker, LocalDate> ev) {
        if (!ev.isFromClient()) {
            return;
        }
        this.onValueChange(model -> model.getDateRange().calcFor((LocalDate)ev.getValue()));
    }

    protected void moveRange(int dif) {
        this.onValueChange(model -> model.getDateRange().moveDateRange(model.getStart(), dif));
    }

    protected void calcModel(Optional<DateRangeResult> optResult, DateRangeModel<D> model) {
        if (optResult.isEmpty()) {
            return;
        }
        DateRangeResult result = optResult.get();
        model.setStart(result.getStart());
        model.setEnd(result.getEnd());
    }

    protected void onValueChange(Function<DateRangeModel<D>, Optional<DateRangeResult>> calcFunc) {
        DateRangeModel<D> model = this.getModelFromComponents();
        this.calcModel(calcFunc.apply(model), model);
        this.updateComponentsFromModel(model);
        DateRangeModel<D> oldValue = this.currentModel;
        this.setCurrentModel(model);
        this.fireValueChanged(oldValue, true);
    }

    protected DateRangeModel<D> getModelFromComponents() {
        return new DateRangeModel<DateRange>((LocalDate)this.dpStart.getValue(), (LocalDate)this.dpEnd.getValue(), (DateRange)this.cbDateRange.getValue());
    }

    protected void updateComponentsFromModel(DateRangeModel<D> model) {
        boolean datepickerReadonly = !model.getDateRange().isSettable();
        this.dpStart.setReadOnly(datepickerReadonly);
        this.dpEnd.setReadOnly(datepickerReadonly);
        boolean fastNavEnabled = model.getDateRange().isMovable();
        this.btnBackwardRange.setEnabled(fastNavEnabled);
        this.btnForwardRange.setEnabled(fastNavEnabled);
        boolean allowRangeLimitExceeding = this.dateRangePicker.isAllowRangeLimitExceeding() && model.getDateRange().isCalcable();
        this.dpEnd.setMin(allowRangeLimitExceeding ? null : model.getStart());
        this.dpStart.setMax(allowRangeLimitExceeding ? null : model.getEnd());
        this.cbDateRange.setValue(model.getDateRange());
        this.dpStart.setValue(model.getStart());
        this.dpEnd.setValue(model.getEnd());
    }

    protected void setCurrentModel(DateRangeModel<D> model) {
        this.currentModel = model;
    }

    protected void fireValueChanged(DateRangeModel<D> oldValue, boolean isFromClient) {
        this.fireEvent(new DateRangeOverlayValueChangeEvent(this, oldValue, isFromClient));
    }

    public void setItems(Collection<D> items) {
        Objects.requireNonNull(items);
        this.getCbDateRange().setItems(items);
    }

    public ComboBox<D> getCbDateRange() {
        return this.cbDateRange;
    }

    public DatePicker getDpStart() {
        return this.dpStart;
    }

    public DatePicker getDpEnd() {
        return this.dpEnd;
    }

    public DateRangeModel<D> getModel() {
        return this.currentModel;
    }

    public void setModel(DateRangeModel<D> model) {
        DateRangeModel<D> oldValue = this.currentModel;
        this.currentModel = model;
        this.updateComponentsFromModel(this.currentModel);
        this.fireValueChanged(oldValue, false);
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.cbDateRange.setReadOnly(readOnly);
        this.btnBackwardRange.setEnabled(!readOnly);
        this.btnForwardRange.setEnabled(!readOnly);
        if (readOnly) {
            this.dpStart.setReadOnly(true);
            this.dpEnd.setReadOnly(true);
        } else {
            this.updateComponentsFromModel(this.getModelFromComponents());
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public Registration addValueChangeListener(ComponentEventListener<DateRangeOverlayValueChangeEvent> listener) {
        return this.addListener(DateRangeOverlayValueChangeEvent.class, listener);
    }

    public class DateRangeOverlayValueChangeEvent
    extends ComponentEvent<DateRangePickerOverlay<D>> {
        private final DateRangeModel<D> oldValue;
        private final boolean isFromClient;

        public DateRangeOverlayValueChangeEvent(DateRangePickerOverlay<D> source, DateRangeModel<D> oldValue, boolean isFromClient) {
            super(source, false);
            this.oldValue = oldValue;
            this.isFromClient = isFromClient;
        }

        public DateRangeModel<D> getOldValue() {
            return this.oldValue;
        }

        public boolean isFromClient() {
            return this.isFromClient;
        }
    }
}

