/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.vaadin.grid_exporter;

import com.vaadin.flow.component.grid.Grid;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import software.xdev.vaadin.grid_exporter.GridExportLocalizationConfig;
import software.xdev.vaadin.grid_exporter.GridExporterProvider;
import software.xdev.vaadin.grid_exporter.column.ColumnConfiguration;
import software.xdev.vaadin.grid_exporter.column.ColumnConfigurationBuilder;
import software.xdev.vaadin.grid_exporter.column.ColumnConfigurationHeaderResolvingStrategyBuilder;
import software.xdev.vaadin.grid_exporter.format.Format;
import software.xdev.vaadin.grid_exporter.grid.GridDataExtractor;
import software.xdev.vaadin.grid_exporter.jasper.JasperGridExporterProvider;
import software.xdev.vaadin.grid_exporter.wizard.GridExporterWizard;
import software.xdev.vaadin.grid_exporter.wizard.GridExporterWizardState;

public class GridExporter<T> {
    protected final Grid<T> grid;
    protected GridExportLocalizationConfig localizationConfig = new GridExportLocalizationConfig();
    protected Predicate<Grid.Column<T>> columnFilter = col -> true;
    protected ColumnConfigurationBuilder columnConfigurationBuilder = new ColumnConfigurationBuilder().withColumnConfigHeaderResolvingStrategyBuilder(ColumnConfigurationHeaderResolvingStrategyBuilder::withVaadinInternalHeaderStrategy);
    protected String fileName = "Report_" + DateTimeFormatter.ofPattern("yyyy_MM_dd_HH_mm").format(LocalDateTime.now(ZoneOffset.UTC));
    protected List<Format> availableFormats = new ArrayList<Format>();
    protected Format preSelectedFormat;
    protected Function<Grid<T>, GridDataExtractor<T>> gridDataExtractorSupplier = GridDataExtractor::new;

    public GridExporter(Grid<T> grid) {
        this.grid = Objects.requireNonNull(grid);
    }

    public GridExporter<T> loadFromProvider(GridExporterProvider provider) {
        this.localizationConfig.withAll(provider.getDefaultTranslationKeyValues());
        this.availableFormats.addAll(provider.getFormats());
        return this;
    }

    public GridExporter<T> withLocalizationConfig(GridExportLocalizationConfig localizationConfig) {
        this.localizationConfig = localizationConfig;
        return this;
    }

    public GridExporter<T> withColumnFilter(Predicate<Grid.Column<T>> columnFilter) {
        this.columnFilter = columnFilter;
        return this;
    }

    public GridExporter<T> withColumnConfigurationBuilder(ColumnConfigurationBuilder columnConfigurationBuilder) {
        this.columnConfigurationBuilder = columnConfigurationBuilder;
        return this;
    }

    public GridExporter<T> withFileName(String fileName) {
        this.fileName = Objects.requireNonNull(fileName);
        return this;
    }

    public GridExporter<T> withAvailableFormats(Format ... availableFormats) {
        return this.withAvailableFormats(Arrays.asList(availableFormats));
    }

    public GridExporter<T> withAvailableFormats(List<Format> availableFormats) {
        Objects.requireNonNull(availableFormats);
        if (availableFormats.isEmpty()) {
            throw new IllegalStateException("Available formats is empty");
        }
        this.availableFormats = new ArrayList<Format>(availableFormats);
        return this;
    }

    public GridExporter<T> addAvailableFormat(Format availableFormat) {
        Objects.requireNonNull(availableFormat);
        this.availableFormats.add(availableFormat);
        return this;
    }

    public GridExporter<T> withPreSelectedFormat(Format preSelectedFormat) {
        Objects.requireNonNull(preSelectedFormat);
        if (!this.availableFormats.contains(preSelectedFormat)) {
            throw new IllegalArgumentException("Available formats must contain Preselected format");
        }
        this.preSelectedFormat = preSelectedFormat;
        return this;
    }

    public GridExporter<T> withGridDataExtractorSupplier(Function<Grid<T>, GridDataExtractor<T>> dataExtractorSupplier) {
        this.gridDataExtractorSupplier = Objects.requireNonNull(dataExtractorSupplier);
        return this;
    }

    protected List<ColumnConfiguration<T>> generateAvailableColumns() {
        return this.grid.getColumns().stream().filter(this.columnFilter).map(this.columnConfigurationBuilder::build).toList();
    }

    public void open() {
        GridExporterWizardState<T> state = new GridExporterWizardState<T>(this.gridDataExtractorSupplier.apply(this.grid), this.availableFormats, this.generateAvailableColumns());
        state.setFileName(this.fileName);
        if (this.preSelectedFormat == null) {
            this.preSelectedFormat = this.availableFormats.get(0);
        }
        state.setSelectedFormat(this.preSelectedFormat);
        new GridExporterWizard<T>(state, this.localizationConfig).open();
    }

    public static <T> GridExporter<T> newWithDefaults(Grid<T> grid) {
        return new GridExporter<T>(grid).loadFromProvider(new JasperGridExporterProvider());
    }
}

