/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.vaadin.grid_exporter.components.wizard.buttonbar;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import software.xdev.vaadin.grid_exporter.components.wizard.panel.WizardPanelActions;
import software.xdev.vaadin.grid_exporter.components.wizard.step.WizardStepState;

@CssImport(value="./styles/wizard.css")
public abstract class AbstractWizardButtonBar<P extends AbstractWizardButtonBar<P>>
extends Composite<HorizontalLayout>
implements HasSize,
HasStyle {
    protected final Button btnCancel = new Button("Cancel");
    protected final Button btnPrevious = new Button("Back");
    protected final Button btnNext = new Button("Next");
    protected final Button btnDone = new Button("Done");
    protected final HorizontalLayout hlEndButtons = new HorizontalLayout();

    protected void init(WizardPanelActions panel) {
        Objects.requireNonNull(panel);
        this.initUI();
        this.registerListeners(panel);
        this.updateFromStepState(new WizardStepState(0, 0));
    }

    protected void initUI() {
        this.btnCancel.addClassName("wizard-button-bar-cancel");
        this.btnPrevious.addClassName("wizard-button-bar-previous");
        this.btnNext.addClassName("wizard-button-bar-next");
        this.btnDone.addClassName("wizard-button-bar-done");
        Stream.of(this.btnCancel, this.btnPrevious, this.btnNext, this.btnDone).forEach(btn -> btn.setDisableOnClick(true));
        Stream.of(this.btnNext, this.btnDone).forEach(btn -> btn.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY}));
        this.hlEndButtons.setPadding(false);
        this.hlEndButtons.add(new Component[]{this.btnPrevious, this.btnNext, this.btnDone});
        ((HorizontalLayout)this.getContent()).addClassName("wizard-button-bar");
        ((HorizontalLayout)this.getContent()).setPadding(false);
        ((HorizontalLayout)this.getContent()).setWidthFull();
        ((HorizontalLayout)this.getContent()).setJustifyContentMode(FlexComponent.JustifyContentMode.BETWEEN);
        ((HorizontalLayout)this.getContent()).add(new Component[]{this.btnCancel, this.hlEndButtons});
    }

    protected void registerListeners(WizardPanelActions panel) {
        this.addButtonClickEvent(this.getBtnPrevious(), panel::showPreviousStep);
        this.addButtonClickEvent(this.getBtnNext(), panel::showNextStep);
        panel.addStepStateChangedListener(this::updateFromStepState);
    }

    protected Registration addButtonClickEvent(Button button, Consumer<Boolean> isFromClientConsumer) {
        return button.addClickListener((ComponentEventListener & Serializable)ev -> {
            isFromClientConsumer.accept(ev.isFromClient());
            ((Button)ev.getSource()).setEnabled(true);
        });
    }

    protected void updateFromStepState(WizardStepState stepState) {
        this.getBtnPrevious().setEnabled(!stepState.isFirstStep());
        this.getBtnNext().setVisible(!stepState.isLastStep());
        this.getBtnDone().setVisible(stepState.isLastStep());
    }

    public Button getBtnCancel() {
        return this.btnCancel;
    }

    public Button getBtnPrevious() {
        return this.btnPrevious;
    }

    public Button getBtnNext() {
        return this.btnNext;
    }

    public Button getBtnDone() {
        return this.btnDone;
    }

    public P configureButton(Function<P, Button> selfButtonSupplier, Consumer<Button> configureButtonAction) {
        configureButtonAction.accept(selfButtonSupplier.apply(this.self()));
        return this.self();
    }

    public P withButtonText(Function<P, Button> selfButtonSupplier, String text) {
        return this.configureButton(selfButtonSupplier, btn -> btn.setText(text));
    }

    public Registration addCancelClickListener(Consumer<Boolean> isFromClientConsumer) {
        return this.addButtonClickEvent(this.getBtnCancel(), isFromClientConsumer);
    }

    public P withCancelClickListener(Consumer<Boolean> isFromClientConsumer) {
        this.addCancelClickListener(isFromClientConsumer);
        return this.self();
    }

    public Registration addDoneClickListener(Consumer<Boolean> isFromClientConsumer) {
        return this.addButtonClickEvent(this.getBtnDone(), isFromClientConsumer);
    }

    public P withDoneClickListener(Consumer<Boolean> isFromClientConsumer) {
        this.addDoneClickListener(isFromClientConsumer);
        return this.self();
    }

    protected P self() {
        return (P)((Object)this);
    }
}

