/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.vaadin.grid_exporter.format;

import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.data.binder.Binder;
import java.util.Objects;
import java.util.function.Supplier;
import software.xdev.vaadin.grid_exporter.Translator;
import software.xdev.vaadin.grid_exporter.format.SpecificConfig;

public abstract class SpecificConfigComponent<T extends SpecificConfig>
extends Composite<FormLayout>
implements Translator {
    protected Translator translator;
    protected Supplier<T> newConfigSupplier;
    protected String header;
    protected Binder<T> binder = new Binder();

    protected SpecificConfigComponent(Translator translator, Supplier<T> newConfigSupplier, String headerToTranslate) {
        this.setTranslator(translator);
        this.setNewConfigSupplier(newConfigSupplier);
        this.setHeaderAndTranslate(headerToTranslate);
        ((FormLayout)this.getContent()).setResponsiveSteps(new FormLayout.ResponsiveStep[]{new FormLayout.ResponsiveStep("0", 1), new FormLayout.ResponsiveStep("400px", 2)});
    }

    protected void setTranslator(Translator translator) {
        this.translator = Objects.requireNonNull(translator);
    }

    protected void setNewConfigSupplier(Supplier<T> newConfigSupplier) {
        this.newConfigSupplier = Objects.requireNonNull(newConfigSupplier);
    }

    protected void setHeader(String header) {
        this.header = header;
    }

    protected void setHeaderAndTranslate(String headerToTranslate) {
        this.setHeader(this.translate(headerToTranslate));
    }

    public Supplier<T> getNewConfigSupplier() {
        return this.newConfigSupplier;
    }

    public String getHeader() {
        return this.header;
    }

    public void updateFrom(T value) {
        this.binder.setBean(value);
    }

    public T getBean() {
        return (T)((SpecificConfig)this.binder.getBean());
    }

    public boolean isValid() {
        return this.binder.isValid();
    }

    @Override
    public String translate(String key) {
        return this.translator != null ? this.translator.translate(key) : key;
    }
}

