/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.vaadin.grid_exporter.grid;

import com.vaadin.flow.component.grid.ColumnPathRenderer;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.renderer.BasicRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.ValueProvider;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import software.xdev.vaadin.grid_exporter.column.ColumnConfiguration;

public class GridDataExtractor<T> {
    protected final Grid<T> grid;

    public GridDataExtractor(Grid<T> grid) {
        this.grid = Objects.requireNonNull(grid);
    }

    public List<List<String>> getSortedAndFilteredData(List<ColumnConfiguration<T>> columnsToExport) {
        return this.getSortedAndFilteredData(this.grid).map(item -> columnsToExport.stream().map(column -> this.getFormattedValue(column.getGridColumn(), item)).toList()).toList();
    }

    protected String getFormattedValue(Grid.Column<T> column, T item) {
        try {
            Renderer renderer = column.getRenderer();
            ValueProvider valueProvider = this.getValueProvider(column);
            if (valueProvider != null) {
                Method getValueFormatter = this.getValueFormatter(renderer);
                Object value = valueProvider.apply(item);
                if (value != null && getValueFormatter != null) {
                    return (String)getValueFormatter.invoke((Object)renderer, value);
                }
            } else if (renderer instanceof ColumnPathRenderer) {
                Field provider = ColumnPathRenderer.class.getDeclaredField("provider");
                provider.setAccessible(true);
                ValueProvider valprov = (ValueProvider)provider.get(renderer);
                if (valprov != null) {
                    return valprov.apply(item).toString();
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
        return null;
    }

    protected <R> Method getValueFormatter(R renderer) {
        for (Method m : renderer.getClass().getDeclaredMethods()) {
            if (!"getFormattedValue".equals(m.getName())) continue;
            m.setAccessible(true);
            return m;
        }
        return null;
    }

    protected <X> ValueProvider<T, X> getValueProvider(Grid.Column<T> column) {
        Renderer r = column.getRenderer();
        if (r instanceof BasicRenderer) {
            try {
                Method getValueProvider = BasicRenderer.class.getDeclaredMethod("getValueProvider", new Class[0]);
                getValueProvider.setAccessible(true);
                return (ValueProvider)getValueProvider.invoke((Object)r, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected Stream<T> getSortedAndFilteredData(Grid<T> grid) {
        return grid.getDataProvider().fetch(new Query(0, Integer.MAX_VALUE, grid.getSortOrder().stream().flatMap(so -> so.getSorted().getSortOrder(so.getDirection())).toList(), (Comparator)grid.getDataCommunicator().getInMemorySorting(), null));
    }
}

