/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.vaadin.grid_exporter.jasper.format;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.function.Function;
import net.sf.jasperreports.engine.JRDataSource;
import software.xdev.dynamicreports.jasper.base.export.AbstractJasperExporter;
import software.xdev.dynamicreports.jasper.builder.JasperReportBuilder;
import software.xdev.dynamicreports.jasper.builder.export.AbstractJasperExporterBuilder;
import software.xdev.dynamicreports.report.builder.DynamicReports;
import software.xdev.dynamicreports.report.builder.column.ColumnBuilder;
import software.xdev.dynamicreports.report.builder.column.Columns;
import software.xdev.dynamicreports.report.builder.column.TextColumnBuilder;
import software.xdev.dynamicreports.report.builder.component.ComponentBuilder;
import software.xdev.dynamicreports.report.builder.component.Components;
import software.xdev.dynamicreports.report.builder.component.PageXofYBuilder;
import software.xdev.dynamicreports.report.builder.component.TextFieldBuilder;
import software.xdev.dynamicreports.report.builder.style.ReportStyleBuilder;
import software.xdev.dynamicreports.report.datasource.DRDataSource;
import software.xdev.dynamicreports.report.exception.DRException;
import software.xdev.vaadin.grid_exporter.column.ColumnConfiguration;
import software.xdev.vaadin.grid_exporter.format.AbstractFormat;
import software.xdev.vaadin.grid_exporter.format.SpecificConfig;
import software.xdev.vaadin.grid_exporter.grid.GridDataExtractor;
import software.xdev.vaadin.grid_exporter.jasper.DynamicExporter;
import software.xdev.vaadin.grid_exporter.jasper.JasperGridReportStyles;
import software.xdev.vaadin.grid_exporter.jasper.config.encoding.EncodingConfig;
import software.xdev.vaadin.grid_exporter.jasper.config.encoding.ExportEncoding;
import software.xdev.vaadin.grid_exporter.jasper.config.header.HeaderConfig;
import software.xdev.vaadin.grid_exporter.jasper.config.highlight.HighlightConfig;
import software.xdev.vaadin.grid_exporter.jasper.config.page.PageConfig;
import software.xdev.vaadin.grid_exporter.jasper.config.title.TitleConfig;

public abstract class AbstractJasperReportFormat<B extends AbstractJasperExporterBuilder<B, ? extends AbstractJasperExporter>>
extends AbstractFormat {
    protected final JasperGridReportStyles jasperGridReportStyles = new JasperGridReportStyles.Default();
    protected final boolean hasPages;
    protected final boolean hasStyle;
    protected final DynamicExporter<B> jasperReportBuilderTo;
    protected final Function<OutputStream, B> jasperExportBuilderSupplier;

    protected AbstractJasperReportFormat(String nameToDisplay, String fileSuffix, String mimeType, boolean hasPages, boolean hasStyle, DynamicExporter<B> jasperReportBuilderTo, Function<OutputStream, B> jasperExportBuilderSupplier) {
        super(nameToDisplay, fileSuffix, mimeType);
        this.hasPages = hasPages;
        this.hasStyle = hasStyle;
        this.jasperReportBuilderTo = jasperReportBuilderTo;
        this.jasperExportBuilderSupplier = jasperExportBuilderSupplier;
    }

    @Override
    public <T> byte[] export(GridDataExtractor<T> gridDataExtractor, List<ColumnConfiguration<T>> columnsToExport, List<? extends SpecificConfig> configs) {
        return this.exportToBytes(this.buildReport(gridDataExtractor, columnsToExport, configs), configs);
    }

    protected byte[] exportToBytes(JasperReportBuilder reportBuilder, List<? extends SpecificConfig> configs) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.getConfigFrom(configs, EncodingConfig.class).filter(EncodingConfig::supportsAndUseBOM).map(EncodingConfig::getSelected).ifPresent(c -> {
            try {
                stream.write(c.bom().getBytes(c.charset()));
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
        });
        this.export(reportBuilder, this.getJasperExportBuilder(stream), configs);
        return stream.toByteArray();
    }

    protected B getJasperExportBuilder(ByteArrayOutputStream stream) {
        return (B)((AbstractJasperExporterBuilder)this.jasperExportBuilderSupplier.apply(stream));
    }

    protected void export(JasperReportBuilder reportBuilder, B exportBuilder, List<? extends SpecificConfig> configs) {
        this.getValueFrom(configs, EncodingConfig.class, EncodingConfig::getSelected).map(ExportEncoding::charset).map(Charset::name).ifPresent(arg_0 -> exportBuilder.setCharacterEncoding(arg_0));
        try {
            this.jasperReportBuilderTo.export(reportBuilder, exportBuilder);
        }
        catch (DRException e) {
            throw new RuntimeException("Failed to export", e);
        }
    }

    protected <T> JasperReportBuilder buildReport(GridDataExtractor<T> gridDataExtractor, List<ColumnConfiguration<T>> columnsToExport, List<? extends SpecificConfig> configs) {
        JasperReportBuilder report = DynamicReports.report();
        columnsToExport.stream().map(this::toReportColumn).forEach(xva$0 -> {
            JasperReportBuilder cfr_ignored_0 = (JasperReportBuilder)report.addColumn(new ColumnBuilder[]{xva$0});
        });
        report.setDataSource((JRDataSource)this.buildDataSource(gridDataExtractor, columnsToExport));
        if (this.hasStyle) {
            report.setColumnTitleStyle((ReportStyleBuilder)this.jasperGridReportStyles.columnTitleStyle());
            report.setColumnStyle((ReportStyleBuilder)this.jasperGridReportStyles.columnStyle());
        }
        report.setIgnorePagination(Boolean.valueOf(!this.hasPages));
        report.setReportName("Report");
        this.getConfigFrom(configs, TitleConfig.class).filter(TitleConfig::notTitleEmpty).map(TitleConfig::getTitle).ifPresent(title -> {
            TextFieldBuilder txtTitle = Components.text((String)title);
            if (this.hasStyle) {
                txtTitle.setStyle((ReportStyleBuilder)this.jasperGridReportStyles.titleStyle());
            }
            report.title(new ComponentBuilder[]{txtTitle});
            report.setReportName(title);
        });
        report.setShowColumnTitle(this.getValueFrom(configs, HeaderConfig.class, HeaderConfig::isExportHeader).orElse(false));
        this.getValueFrom(configs, HighlightConfig.class, HighlightConfig::isHighlightOddRows).filter(highlight -> highlight).ifPresent(x -> {
            report.setDetailOddRowStyle(this.jasperGridReportStyles.columnStyleHighlighted());
            report.highlightDetailOddRows();
        });
        this.getConfigFrom(configs, PageConfig.class).ifPresent(pc -> {
            report.setPageFormat(pc.getSelectedPageType(), pc.getSelectedPageOrientation());
            if (pc.isUsePageNumbering()) {
                PageXofYBuilder pageXofYBuilder = DynamicReports.cmp.pageXofY();
                if (this.hasStyle) {
                    pageXofYBuilder.setStyle((ReportStyleBuilder)this.jasperGridReportStyles.footerStyle());
                }
                report.pageFooter(new ComponentBuilder[]{pageXofYBuilder});
            }
            report.setPageMargin(DynamicReports.margin((int)pc.getPageMargin()));
        });
        return report;
    }

    protected <T> DRDataSource buildDataSource(GridDataExtractor<T> gridDataExtractor, List<ColumnConfiguration<T>> columnsToExport) {
        DRDataSource dataSource = new DRDataSource((String[])columnsToExport.stream().map(ColumnConfiguration::getHeader).toArray(String[]::new));
        gridDataExtractor.getSortedAndFilteredData(columnsToExport).stream().map(List::toArray).forEach(arg_0 -> ((DRDataSource)dataSource).add(arg_0));
        return dataSource;
    }

    protected TextColumnBuilder<String> toReportColumn(ColumnConfiguration<?> column) {
        return Columns.column((String)column.getHeader(), (String)column.getHeader(), String.class);
    }
}

