/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.vaadin.grid_exporter.wizard;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.router.AfterNavigationEvent;
import com.vaadin.flow.router.AfterNavigationObserver;
import com.vaadin.flow.server.AbstractStreamResource;
import java.io.Serializable;
import java.util.Objects;
import software.xdev.vaadin.grid_exporter.GridExportLocalizationConfig;
import software.xdev.vaadin.grid_exporter.Translator;
import software.xdev.vaadin.grid_exporter.components.wizard.buttonbar.AbstractWizardButtonBar;
import software.xdev.vaadin.grid_exporter.components.wizard.buttonbar.WizardButtonBarWithAnchor;
import software.xdev.vaadin.grid_exporter.components.wizard.panel.WizardPanel;
import software.xdev.vaadin.grid_exporter.wizard.GridExporterWizardState;
import software.xdev.vaadin.grid_exporter.wizard.steps.FormatStep;
import software.xdev.vaadin.grid_exporter.wizard.steps.GeneralStep;
import software.xdev.vaadin.grid_exporter.wizard.steps.PreviewStep;

public class GridExporterWizard<T>
extends Dialog
implements AfterNavigationObserver,
Translator {
    protected final Button closeButton = new Button((Component)VaadinIcon.CLOSE.create());
    protected final WizardPanel<GridExporterWizardState<T>> wizardPanel = new WizardPanel();
    protected final WizardButtonBarWithAnchor buttonBar = new WizardButtonBarWithAnchor(this.wizardPanel);
    protected final PreviewStep<T> previewStep;
    protected final GridExportLocalizationConfig localizationConfig;

    public GridExporterWizard(GridExporterWizardState<T> initialState, GridExportLocalizationConfig localizationConfig) {
        this.localizationConfig = Objects.requireNonNull(localizationConfig);
        this.previewStep = new PreviewStep(this);
        this.initUI();
        this.registerListeners();
        this.wizardPanel.setState(initialState);
    }

    protected void initUI() {
        this.setHeaderTitle(this.translate("gridexporter.export_grid"));
        this.closeButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY});
        this.getHeader().add(new Component[]{this.closeButton});
        this.addStepsToWizardPanel();
        this.add(new Component[]{this.wizardPanel});
        this.buttonBar.withButtonText(AbstractWizardButtonBar::getBtnCancel, this.translate("gridexporter.cancel"));
        this.buttonBar.withButtonText(AbstractWizardButtonBar::getBtnPrevious, this.translate("gridexporter.previous"));
        this.buttonBar.withButtonText(AbstractWizardButtonBar::getBtnNext, this.translate("gridexporter.next"));
        this.buttonBar.withButtonText(AbstractWizardButtonBar::getBtnDone, this.translate("gridexporter.download"));
        this.buttonBar.getAnchorDone().getElement().setAttribute("download", true);
        this.buttonBar.getBtnDone().setIcon((Component)VaadinIcon.DOWNLOAD.create());
        this.getFooter().add(new Component[]{this.buttonBar});
        this.setResizable(true);
        this.setDraggable(true);
        this.setWidth("80%");
        this.setMaxWidth("70em");
        this.setHeight("90%");
        this.setMaxHeight("70em");
    }

    protected void addStepsToWizardPanel() {
        this.wizardPanel.addStep(new GeneralStep(this));
        this.wizardPanel.addStep(new FormatStep(this));
        this.wizardPanel.addStep(this.previewStep);
    }

    protected void registerListeners() {
        this.closeButton.addClickListener((ComponentEventListener & Serializable)ev -> this.close());
        this.buttonBar.addCancelClickListener(ev -> this.close());
        this.previewStep.addStreamResourceGeneratedListener((ComponentEventListener & Serializable)ev -> this.buttonBar.getAnchorDone().setHref((AbstractStreamResource)ev.getResource()));
        this.wizardPanel.addStepStateChangedListener(ev -> {
            if (!ev.isLastStep() && !this.buttonBar.getAnchorDone().getHref().isBlank()) {
                this.buttonBar.getAnchorDone().setHref("");
            }
        });
    }

    public void afterNavigation(AfterNavigationEvent event) {
        this.close();
    }

    @Override
    public String translate(String key) {
        return this.localizationConfig.getTranslation(key, (Component)this);
    }
}

