/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.vaadin.grid_exporter.wizard.steps;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridVariant;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.textfield.TextFieldVariant;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import software.xdev.vaadin.grid_exporter.Translator;
import software.xdev.vaadin.grid_exporter.column.ColumnConfiguration;
import software.xdev.vaadin.grid_exporter.wizard.GridExporterWizardState;
import software.xdev.vaadin.grid_exporter.wizard.steps.AbstractGridExportWizardStepComposite;

public class GeneralStep<T>
extends AbstractGridExportWizardStepComposite<FormLayout, T> {
    protected final Binder<GridExporterWizardState<T>> binder = new Binder();
    protected final TextField txtFileName = new TextField();
    protected final Grid<ColumnConfiguration<T>> gridColumns = new Grid();
    protected final Map<ColumnConfiguration<T>, Binder<ColumnConfiguration<T>>> columnBinders = new HashMap<ColumnConfiguration<T>, Binder<ColumnConfiguration<T>>>();
    protected Registration gridSelectionChanged;

    public GeneralStep(Translator translator) {
        super(translator);
        this.setStepName(this.translate("gridexporter.general"));
        this.initUI();
        this.initBindings();
    }

    protected void initUI() {
        this.txtFileName.setAllowedCharPattern("[^<>:\"|?* \\\\\\/\\.]");
        this.txtFileName.setWidthFull();
        ((Grid.Column)this.gridColumns.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)v -> {
            Binder nameBinder = new Binder();
            TextField txtField = new TextField();
            txtField.setRequired(true);
            txtField.setWidthFull();
            txtField.addThemeVariants((ThemeVariant[])new TextFieldVariant[]{TextFieldVariant.LUMO_SMALL});
            nameBinder.forField((HasValue)txtField).asRequired().withValidator((SerializablePredicate & Serializable)s -> ((GridExporterWizardState)this.getWizardState()).getSelectedColumns().stream().filter(colToCheck -> !Objects.equals(colToCheck, v)).map(ColumnConfiguration::getHeader).noneMatch(header -> Objects.equals(s, header)), this.translate("gridexporter.already_present")).bind(ColumnConfiguration::getHeader, ColumnConfiguration::setHeader);
            nameBinder.setBean(v);
            nameBinder.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validateGrid());
            this.columnBinders.put((ColumnConfiguration)v, (Binder)nameBinder);
            return txtField;
        })).setHeader(this.translate("gridexporter.name")).setResizable(true)).setSortable(false).setAutoWidth(true).setFlexGrow(1);
        this.gridColumns.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)v -> {
            Button up = new Button((Component)VaadinIcon.ARROW_UP.create(), (ComponentEventListener & Serializable)e -> this.move(false, (ColumnConfiguration)v));
            up.setEnabled(this.isMovingPossible(false, (ColumnConfiguration)v));
            Button down = new Button((Component)VaadinIcon.ARROW_DOWN.create(), (ComponentEventListener & Serializable)e -> this.move(true, (ColumnConfiguration)v));
            down.setEnabled(this.isMovingPossible(true, (ColumnConfiguration)v));
            Stream.of(up, down).forEach(btn -> btn.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL}));
            HorizontalLayout hlContainer = new HorizontalLayout(new Component[]{up, down});
            hlContainer.setSizeFull();
            hlContainer.setMargin(false);
            hlContainer.setPadding(false);
            return hlContainer;
        })).setHeader(this.translate("gridexporter.position")).setSortable(false).setAutoWidth(true).setFlexGrow(0);
        this.gridColumns.addThemeVariants(new GridVariant[]{GridVariant.LUMO_COMPACT});
        this.gridColumns.setAllRowsVisible(true);
        this.gridColumns.setSelectionMode(Grid.SelectionMode.MULTI);
        ((FormLayout)this.getContent()).setResponsiveSteps(new FormLayout.ResponsiveStep[]{new FormLayout.ResponsiveStep("0", 1, FormLayout.ResponsiveStep.LabelsPosition.TOP)});
        ((FormLayout)this.getContent()).addFormItem((Component)this.txtFileName, this.translate("gridexporter.filename"));
        ((FormLayout)this.getContent()).addFormItem(this.gridColumns, this.translate("gridexporter.columns"));
        ((FormLayout)this.getContent()).setSizeFull();
    }

    protected void initBindings() {
        this.binder.forField((HasValue)this.txtFileName).asRequired().bind(GridExporterWizardState::getFileName, GridExporterWizardState::setFileName);
    }

    @Override
    public void onEnterStep(GridExporterWizardState<T> state) {
        this.binder.setBean(state);
        if (this.gridSelectionChanged != null) {
            this.gridSelectionChanged.remove();
        }
        this.gridColumns.setItems(DataProvider.ofCollection(state.getAvailableColumns()));
        state.getSelectedColumns().forEach(arg_0 -> this.gridColumns.select(arg_0));
        this.gridSelectionChanged = this.gridColumns.addSelectionListener((SelectionListener & Serializable)ev -> {
            ((GridExporterWizardState)this.getWizardState()).setSelectedColumns(new ArrayList(ev.getAllSelectedItems()));
            this.validateGrid();
        });
    }

    protected void validateGrid() {
        this.gridColumns.getStyle().set("border", this.isColumnsInvalid((GridExporterWizardState)this.getWizardState()) ? "1px solid var(--lumo-error-color-50pct)" : null);
    }

    @Override
    public boolean onProgress(GridExporterWizardState<T> state) {
        if (this.isColumnsInvalid(state)) {
            return false;
        }
        return this.binder.isValid();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isColumnsInvalid(GridExporterWizardState<T> state) {
        List<ColumnConfiguration<T>> selCols = state.getSelectedColumns();
        if (selCols.isEmpty()) return true;
        if (!state.getSelectedColumns().stream().map(this.columnBinders::get).anyMatch(b -> b == null || !b.isValid())) return false;
        return true;
    }

    protected boolean isMovingPossible(boolean increment, ColumnConfiguration<T> column) {
        List columns = ((GridExporterWizardState)this.getWizardState()).getAvailableColumns();
        if (columns.size() <= 1) {
            return false;
        }
        int index = columns.indexOf(column);
        return increment && index < columns.size() - 1 || !increment && index > 0;
    }

    protected void move(boolean increment, ColumnConfiguration<T> column) {
        if (!this.isMovingPossible(increment, column)) {
            return;
        }
        List columns = ((GridExporterWizardState)this.getWizardState()).getAvailableColumns();
        int index = columns.indexOf(column);
        Collections.swap(columns, index - (increment ? 0 : 1), index + (increment ? 1 : 0));
        ((GridExporterWizardState)this.getWizardState()).getSelectedColumns().sort(Comparator.comparing(columns::indexOf));
        this.gridColumns.getDataProvider().refreshAll();
    }
}

