/*
 * Decompiled with CFR 0.152.
 */
package solutions.deepfield.spark.itcase.annotations;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import solutions.deepfield.spark.itcase.annotations.SparkAfter;
import solutions.deepfield.spark.itcase.annotations.SparkBefore;

public class SparkSubmitTestWrapper {
    private static final Logger logger = LoggerFactory.getLogger(SparkSubmitTestWrapper.class);

    public static void main(String[] args) {
        try {
            Class<?> examineTarget;
            if (args.length < 2) {
                throw new Exception("Did not specify class to run or test method");
            }
            String classToRun = args[0];
            logger.info("Test class is [" + classToRun + "]");
            Class<?> testClass = SparkSubmitTestWrapper.class.getClassLoader().loadClass(classToRun);
            logger.info("Loaded test class");
            String methodToTest = args[1];
            Method method = testClass.getMethod(methodToTest, new Class[0]);
            if (method == null) {
                throw new Exception("Unable to find test method [" + method + "] with zero arguments");
            }
            ArrayList<Method> befores = new ArrayList<Method>();
            for (examineTarget = testClass; examineTarget != null; examineTarget = examineTarget.getSuperclass()) {
                for (Method m : testClass.getMethods()) {
                    if (m.getAnnotation(SparkBefore.class) == null) continue;
                    if (m.getParameterTypes().length > 0) {
                        throw new Exception("Found @SparkBefore annotation on method with arguments");
                    }
                    befores.add(m);
                }
            }
            ArrayList<Method> afters = new ArrayList<Method>();
            for (examineTarget = testClass; examineTarget != null; examineTarget = examineTarget.getSuperclass()) {
                for (Method m : testClass.getMethods()) {
                    if (m.getAnnotation(SparkAfter.class) == null) continue;
                    if (m.getParameterTypes().length > 0) {
                        throw new Exception("Found @SparkAfter annotation on method with arguments");
                    }
                    afters.add(m);
                }
            }
            Object instance = testClass.newInstance();
            for (Method before : befores) {
                logger.info("Invoking before method [" + before.getDeclaringClass() + "#" + before.getName() + "]");
                before.invoke(instance, new Object[0]);
                logger.info("Finished before method [" + before.getDeclaringClass() + "#" + before.getName() + "]");
            }
            method.invoke(instance, new Object[0]);
            for (Method after : afters) {
                logger.info("Invoking after method [" + after.getDeclaringClass() + "#" + after.getName() + "]");
                after.invoke(instance, new Object[0]);
                logger.info("Finished after method [" + after.getDeclaringClass() + "#" + after.getName() + "]");
            }
        }
        catch (Exception e) {
            logger.error("Error processing command: " + e.getMessage(), (Throwable)e);
            System.exit(10);
        }
    }
}

