/*
 * Decompiled with CFR 0.152.
 */
package solutions.linked.slds;

import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.net.ssl.SSLContext;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.clerezza.commons.rdf.Literal;
import org.apache.clerezza.rdf.core.LiteralFactory;
import org.apache.clerezza.rdf.utils.GraphNode;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import solutions.linked.slds.SLDS;

public class ConfigUtils {
    final GraphNode config;

    public ConfigUtils(GraphNode config) {
        this.config = config;
    }

    public CloseableHttpClient createHttpClient() {
        try {
            HttpClientBuilder hcb = HttpClientBuilder.create();
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            this.addCredentials((CredentialsProvider)credsProvider);
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            hcb.setSSLContext(sslContext);
            return hcb.setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void addCredentials(CredentialsProvider credsProvider) {
        if (this.getSparqlEndpointNode().getLiterals(SLDS.userName).hasNext()) {
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.getUserName(), this.getPassword());
            credsProvider.setCredentials(AuthScope.ANY, (Credentials)credentials);
        }
    }

    public String getUserName() {
        return ((Literal)this.getSparqlEndpointNode().getLiterals(SLDS.userName).next()).getLexicalForm();
    }

    public String getPassword() {
        return ((Literal)this.getSparqlEndpointNode().getLiterals(SLDS.password).next()).getLexicalForm();
    }

    public GraphNode getSparqlEndpointNode() {
        try {
            return (GraphNode)this.config.getObjectNodes(SLDS.sparqlEndpoint).next();
        }
        catch (NoSuchElementException ex) {
            throw new NoSuchElementException("the resource " + this.config.getNode() + " has no " + SLDS.sparqlEndpoint + " property.");
        }
    }

    public IRI getSparqlEndpointUri() {
        return (IRI)this.getSparqlEndpointNode().getNode();
    }

    public boolean enableVituosoWorkAround() {
        Iterator literals = this.config.getLiterals(SLDS.enableVituosoWorkAround);
        return literals.hasNext() && (Boolean)LiteralFactory.getInstance().createObject(Boolean.class, (Literal)literals.next()) != false;
    }
}

