/*
 * Decompiled with CFR 0.152.
 */
package solutions.linked.slds;

import java.io.IOException;
import java.net.URI;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.UriBuilder;

@PreMatching
public class EffectiveRequestUriFilter
implements ContainerRequestFilter {
    public void filter(ContainerRequestContext requestContext) throws IOException {
        URI requestUri = requestContext.getUriInfo().getRequestUri();
        String hostHeader = (String)requestContext.getHeaders().getFirst((Object)"Host");
        if (hostHeader == null) {
            System.out.println("WARN: No Host header in request");
            return;
        }
        int hostHeaderSeparator = hostHeader.indexOf(58);
        String host = hostHeaderSeparator > -1 ? hostHeader.substring(0, hostHeaderSeparator) : hostHeader;
        int port = hostHeaderSeparator > -1 ? Integer.parseInt(hostHeader.substring(hostHeaderSeparator + 1)) : -1;
        String xForwardedProto = (String)requestContext.getHeaders().getFirst((Object)"X-Forwarded-Proto");
        UriBuilder uriBuilder = xForwardedProto != null ? UriBuilder.fromUri((URI)requestUri).scheme(xForwardedProto) : UriBuilder.fromUri((URI)requestUri);
        URI fixedUri = uriBuilder.port(port).host(host).build(new Object[0]);
        requestContext.setRequestUri(fixedUri);
    }
}

