/*
 * Decompiled with CFR 0.152.
 */
package solutions.linked.slds;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.ws.rs.Path;
import org.apache.clerezza.commons.rdf.Graph;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.clerezza.commons.rdf.Literal;
import org.apache.clerezza.rdf.utils.GraphNode;
import org.apache.clerezza.rdf.utils.UnionGraph;
import solutions.linked.slds.ResourceDescriptionProvider;
import solutions.linked.slds.RootResource;
import solutions.linked.slds.SLDS;

@Path(value="")
public class ExtensibleRootResource
extends RootResource {
    final Collection<ResourceDescriptionProvider> resourceDescriptionProviders;

    public ExtensibleRootResource(GraphNode config) {
        super(config);
        Iterator objectNodes = config.getObjectNodes(SLDS.resourceDescriptionProvider);
        this.resourceDescriptionProviders = new ArrayList<ResourceDescriptionProvider>();
        while (objectNodes.hasNext()) {
            GraphNode rdpNode = (GraphNode)objectNodes.next();
            ResourceDescriptionProvider rdp = this.getRdpFromResource(rdpNode);
            this.resourceDescriptionProviders.add(rdp);
        }
        if (this.resourceDescriptionProviders.isEmpty()) {
            throw new RuntimeException("No ResourceDescriptionProvider found in config");
        }
    }

    @Override
    protected Graph getGraphFor(IRI effectiveResource) throws IOException {
        ArrayList<Graph> graphs = new ArrayList<Graph>();
        for (ResourceDescriptionProvider rdp : this.resourceDescriptionProviders) {
            graphs.add(rdp.getGraphFor(effectiveResource));
        }
        return new UnionGraph(graphs.toArray(new Graph[graphs.size()]));
    }

    private ResourceDescriptionProvider getRdpFromResource(GraphNode rdpNode) {
        String className = ((Literal)rdpNode.getLiterals(SLDS.javaClass).next()).getLexicalForm();
        try {
            return (ResourceDescriptionProvider)Class.forName(className).getConstructor(GraphNode.class).newInstance(rdpNode);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("ResourceDescriptionProvider " + className + " must have a public constructore with a GraphNode as argument", ex);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }
}

