/*
 * Decompiled with CFR 0.152.
 */
package solutions.linked.slds;

import java.io.IOException;
import java.net.URI;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.apache.clerezza.commons.rdf.Graph;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.clerezza.rdf.utils.GraphNode;
import solutions.linked.slds.ConfigUtils;
import solutions.linked.slds.util.IriTranslatorProvider;

@Path(value="")
public abstract class RootResource {
    public final GraphNode config;
    private final IriTranslatorProvider iriTranslatorProvider;
    private final ConfigUtils configUtils;

    public RootResource(GraphNode config) {
        this.config = config;
        this.iriTranslatorProvider = new IriTranslatorProvider(config);
        this.configUtils = new ConfigUtils(config);
    }

    @GET
    @Path(value="{path : .*}")
    public Graph getResourceDescription(@Context HttpHeaders httpHeaders, @Context UriInfo uriInfo) throws IOException {
        URI requestUri = uriInfo.getRequestUri();
        IRI resource = new IRI(requestUri.toString());
        return this.getGraphFor(resource);
    }

    protected abstract Graph getGraphFor(IRI var1) throws IOException;
}

