/*
 * Decompiled with CFR 0.152.
 */
package solutions.linked.slds;

import com.sun.net.httpserver.HttpServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.clerezza.commons.rdf.Graph;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.clerezza.commons.rdf.ImmutableGraph;
import org.apache.clerezza.commons.rdf.Literal;
import org.apache.clerezza.rdf.core.serializedform.Parser;
import org.apache.clerezza.rdf.utils.GraphNode;
import org.apache.clerezza.rdf.utils.UnionGraph;
import org.jboss.resteasy.plugins.server.sun.http.HttpContextBuilder;
import solutions.linked.slds.CORSFilter;
import solutions.linked.slds.DummyWriter;
import solutions.linked.slds.EffectiveRequestUriFilter;
import solutions.linked.slds.ExtensibleRootResource;
import solutions.linked.slds.MyGraphWriter;
import solutions.linked.slds.SLDS;
import solutions.linked.slds.VaryFilter;

public class Server
implements Runnable {
    public final GraphNode config;

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Argument pointing to configuration required");
            return;
        }
        new Server(args).run();
    }

    public Server(String[] args) throws FileNotFoundException {
        ImmutableGraph configCraph = null;
        IRI configIRI = null;
        for (int i = 0; i < args.length; ++i) {
            File configFile = new File(args[i]);
            if (!configFile.exists()) {
                throw new FileNotFoundException("Could not find: " + configFile.getAbsolutePath());
            }
            String configFileURI = "file://" + configFile.toURI().normalize().toString().substring(5);
            IRI currentFileIRI = new IRI(configFileURI);
            if (i == 0) {
                configIRI = currentFileIRI;
            }
            ImmutableGraph currentFileConfig = Parser.getInstance().parse((InputStream)new FileInputStream(configFile), "text/turtle", currentFileIRI);
            configCraph = configCraph == null ? currentFileConfig : new UnionGraph(new Graph[]{configCraph, currentFileConfig});
        }
        this.config = new GraphNode(configIRI, configCraph);
    }

    public Server(GraphNode config) {
        this.config = config;
    }

    @Override
    public void run() {
        HttpServer server;
        int port = Integer.parseInt(((Literal)this.config.getLiterals(SLDS.port).next()).getLexicalForm());
        try {
            server = HttpServer.create(new InetSocketAddress(port), 1);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        HttpContextBuilder contextBuilder = new HttpContextBuilder();
        contextBuilder.getDeployment().setApplication(new Application(){

            public Set<Object> getSingletons() {
                return Server.this.getJaxRsComponents();
            }
        });
        contextBuilder.bind(server);
        server.start();
    }

    protected Set<Object> getJaxRsComponents() {
        HashSet<Object> result = new HashSet<Object>();
        result.add(this.getRootResource());
        result.add(this.getGraphMBW());
        result.add(new DummyWriter());
        result.add(new CORSFilter());
        result.add(new VaryFilter());
        result.add(new EffectiveRequestUriFilter());
        return result;
    }

    protected MessageBodyWriter getGraphMBW() {
        return new MyGraphWriter();
    }

    protected Object getRootResource() {
        return new ExtensibleRootResource(this.config);
    }
}

