/*
 * Decompiled with CFR 0.152.
 */
package solutions.linked.slds.providers;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.clerezza.commons.rdf.Graph;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.clerezza.commons.rdf.Literal;
import org.apache.clerezza.commons.rdf.impl.utils.simple.SimpleGraph;
import org.apache.clerezza.rdf.core.serializedform.Parser;
import org.apache.clerezza.rdf.utils.GraphNode;
import solutions.linked.slds.ResourceDescriptionProvider;
import solutions.linked.slds.SLDS;
import solutions.linked.slds.translation.IriTranslator;
import solutions.linked.slds.util.IriTranslatorProvider;

public class FileResourceDescription
implements ResourceDescriptionProvider {
    public final IRI resource;
    public final Graph graph;
    public final IriTranslator iriTranslator;

    public FileResourceDescription(GraphNode config) {
        this.iriTranslator = new IriTranslatorProvider(config).getIriTranslator();
        this.resource = this.iriTranslator.translate((IRI)config.getObjects(SLDS.resource).next());
        String filePath = ((Literal)config.getLiterals(SLDS.file).next()).getLexicalForm();
        try {
            this.graph = this.iriTranslator.translate((Graph)Parser.getInstance().parse((InputStream)new FileInputStream(filePath), "text/turtle"));
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Graph getGraphFor(IRI resource) {
        if (this.resource.equals((Object)resource)) {
            return this.graph;
        }
        return new SimpleGraph();
    }
}

