/*
 * Decompiled with CFR 0.152.
 */
package solutions.linked.slds.providers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.apache.clerezza.commons.rdf.Graph;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.clerezza.rdf.core.serializedform.Parser;
import org.apache.clerezza.rdf.utils.GraphNode;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import solutions.linked.slds.ConfigUtils;
import solutions.linked.slds.ResourceDescriptionProvider;
import solutions.linked.slds.util.IriTranslatorProvider;

public class GraphAndContext
implements ResourceDescriptionProvider {
    public final GraphNode config;
    public final IriTranslatorProvider iriTranslatorProvider;
    public final ConfigUtils configUtils;

    public GraphAndContext(GraphNode config) {
        this.config = config;
        this.configUtils = new ConfigUtils(config);
        this.iriTranslatorProvider = new IriTranslatorProvider(config);
    }

    @Override
    public Graph getGraphFor(IRI resource) {
        IRI effectiveResource = this.iriTranslatorProvider.getIriTranslator().reverse().translate(resource);
        String[] queries = this.getQueries(effectiveResource);
        try {
            return this.runQueries(queries);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected Graph runQueries(String[] queries) throws IOException {
        SequenceInputStream in = new SequenceInputStream(this.getQueryResultsAsStream(queries));
        return this.iriTranslatorProvider.getIriTranslator().translate((Graph)Parser.getInstance().parse((InputStream)in, "application/n-triples"));
    }

    protected Enumeration<? extends InputStream> getQueryResultsAsStream(String[] queries) throws IOException {
        try (CloseableHttpClient httpClient = this.configUtils.createHttpClient();){
            Enumeration enumeration = Collections.enumeration(Arrays.asList(queries).stream().map(query -> {
                ByteArrayInputStream byteArrayInputStream;
                block12: {
                    HttpPost httpPost = new HttpPost(this.configUtils.getSparqlEndpointUri().getUnicodeString());
                    if (this.configUtils.enableVituosoWorkAround()) {
                        httpPost.setHeader("Accept", "text/plain");
                    } else {
                        httpPost.setHeader("Accept", "application/n-triples");
                    }
                    httpPost.setEntity((HttpEntity)new StringEntity(query, ContentType.create((String)"application/sparql-query", (String)"utf-8")));
                    CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                    try {
                        StatusLine statusLine = response.getStatusLine();
                        if (statusLine.getStatusCode() >= 400) {
                            throw new IOException("HTTP " + statusLine.getStatusCode() + " " + statusLine.getReasonPhrase());
                        }
                        String responseType = response.getFirstHeader("Content-Type").getValue();
                        if (!(responseType.startsWith("application/n-triples") || this.configUtils.enableVituosoWorkAround() && responseType.startsWith("text/plain"))) {
                            System.err.println("The SPARQL server did not retun n-triples but " + responseType);
                            System.err.println(new String(EntityUtils.toByteArray((HttpEntity)response.getEntity()), "utf-8"));
                            throw new RuntimeException("The SPARQL server did not retun n-triples but " + responseType);
                        }
                        byte[] responseBody = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                        byteArrayInputStream = new ByteArrayInputStream(responseBody);
                        if (response == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (response != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    response.close();
                }
                return byteArrayInputStream;
            }).collect(Collectors.toList()));
            return enumeration;
        }
    }

    protected String[] getQueries(IRI resource) {
        String describeQuery = "DESCRIBE <" + resource.getUnicodeString() + ">";
        HashSet<String> resultSet = new HashSet<String>();
        if (this.configUtils.enableVituosoWorkAround()) {
            resultSet.add("define sql:describe-mode \"CBD\" " + describeQuery);
            resultSet.add("define sql:describe-mode \"OBJCBD\" " + describeQuery);
        } else {
            resultSet.add(describeQuery);
        }
        resultSet.add("CONSTRUCT {?sub ?pred ?obj} WHERE { GRAPH <" + resource.getUnicodeString() + "> {  ?sub ?pred ?obj . } }");
        return resultSet.toArray(new String[resultSet.size()]);
    }
}

