/*
 * Decompiled with CFR 0.152.
 */
package solutions.linked.slds.translation;

import org.apache.clerezza.commons.rdf.Graph;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.clerezza.rdf.utils.UriMutatingGraph;
import solutions.linked.slds.translation.IriTranslator;

public class IriNamespaceTranslator
implements IriTranslator {
    final String origPrefix;
    final String targetPrefix;

    public IriNamespaceTranslator(String origPrefix, String targetPrefix) {
        this.origPrefix = origPrefix;
        this.targetPrefix = targetPrefix;
    }

    @Override
    public IriTranslator reverse() {
        return new IriNamespaceTranslator(this.targetPrefix, this.origPrefix);
    }

    @Override
    public IRI translate(IRI orig) {
        String origString = orig.getUnicodeString();
        if (origString.startsWith(this.origPrefix)) {
            return new IRI(this.targetPrefix + origString.substring(this.origPrefix.length()));
        }
        return orig;
    }

    @Override
    public Graph translate(Graph orig) {
        return new UriMutatingGraph(orig, this.origPrefix, this.targetPrefix);
    }
}

