/*
 * Decompiled with CFR 0.152.
 */
package solutions.linked.slds.util;

import org.apache.clerezza.commons.rdf.Literal;
import org.apache.clerezza.rdf.ontologies.RDF;
import org.apache.clerezza.rdf.utils.GraphNode;
import solutions.linked.slds.SLDS;
import solutions.linked.slds.translation.ChainedIriTranslator;
import solutions.linked.slds.translation.IriNamespaceTranslator;
import solutions.linked.slds.translation.IriTranslator;
import solutions.linked.slds.translation.NillIriTranslator;

public class IriTranslatorProvider {
    private final GraphNode config;

    public IriTranslatorProvider(GraphNode config) {
        this.config = config;
    }

    public IriTranslator getIriTranslator() {
        if (this.config.getObjectNodes(SLDS.iriTranslators).hasNext()) {
            GraphNode next = (GraphNode)this.config.getObjectNodes(SLDS.iriTranslators).next();
            return this.getIriTranslatorFromList(next);
        }
        return new NillIriTranslator();
    }

    private IriTranslator getIriTranslatorFromList(GraphNode list) {
        if (list.getNode().equals(RDF.nil)) {
            return new NillIriTranslator();
        }
        return new ChainedIriTranslator(this.getIriTranslator((GraphNode)list.getObjectNodes(RDF.first).next()), this.getIriTranslatorFromList((GraphNode)list.getObjectNodes(RDF.rest).next()));
    }

    private IriTranslator getIriTranslator(GraphNode node) {
        return new IriNamespaceTranslator(((Literal)node.getLiterals(SLDS.backendPrefix).next()).getLexicalForm(), ((Literal)node.getLiterals(SLDS.frontendPrefix).next()).getLexicalForm());
    }
}

