/*
 * Decompiled with CFR 0.152.
 */
package space.glome.http.schema;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Set;
import space.glome.schema.domain.Argument;

public class IntegerDeserializer
extends StdDeserializer<Integer> {
    private static final long serialVersionUID = 1L;
    private Set<Argument> arguments;

    public IntegerDeserializer(Set<Argument> arguments) {
        super(Integer.class);
        this.arguments = arguments;
    }

    public Integer deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        String text = node.asText();
        for (Argument argument : this.arguments) {
            text = text.replace("${" + argument.getKey() + "}", argument.getValue());
        }
        return Integer.parseInt(text);
    }
}

