/*
 * Decompiled with CFR 0.152.
 */
package space.glome.http.schema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import space.glome.http.schema.IntegerDeserializer;
import space.glome.http.schema.StringDeserializer;
import space.glome.http.schema.domain.HttpRequest;
import space.glome.http.schema.domain.HttpRequestItem;
import space.glome.schema.domain.Argument;

public class JsonMarshallingUtils {
    public static String marshal(Object value) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(value);
    }

    public static HttpRequestItem unmarshalHttpRequestItem(String requestFilePath) throws Exception {
        return JsonMarshallingUtils.unmarshalHttpRequestItem(requestFilePath, null);
    }

    public static HttpRequestItem unmarshalHttpRequestItem(String requestFilePath, Set<Argument> arguments) throws Exception {
        Set defaultArguments;
        HttpRequestItem requestItem = JsonMarshallingUtils.unmarshal(JsonMarshallingUtils.readFile(requestFilePath), HttpRequestItem.class, arguments);
        HashSet<Argument> finalArguments = new HashSet<Argument>();
        if (arguments != null) {
            finalArguments.addAll(arguments);
        }
        if ((defaultArguments = requestItem.getArguments()) != null) {
            for (Argument argument : defaultArguments) {
                if (argument.getValue() == null) continue;
                finalArguments.add(argument);
            }
        }
        ((HttpRequest)requestItem.getRequest()).setArguments(arguments);
        return requestItem;
    }

    private static String readFile(String filePath) throws IOException {
        try (Scanner scanner = new Scanner(JsonMarshallingUtils.class.getResourceAsStream(filePath), "UTF-8");){
            String string = scanner.useDelimiter("\\A").next();
            return string;
        }
    }

    private static <E> E unmarshal(String content, Class<E> clazz, Set<Argument> arguments) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        if (arguments != null) {
            module.addDeserializer(String.class, (JsonDeserializer)new StringDeserializer(arguments));
            module.addDeserializer(Integer.class, (JsonDeserializer)new IntegerDeserializer(arguments));
        }
        mapper.registerModule((Module)module);
        return (E)mapper.readValue(content, clazz);
    }
}

