/*
 * Decompiled with CFR 0.152.
 */
package space.glome.http.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import java.io.IOException;
import java.util.Iterator;
import java.util.Scanner;
import space.glome.http.schema.JsonMarshallingUtils;

public class JsonValidationUtils {
    public static final String JSON_V4_SCHEMA_IDENTIFIER = "http://json-schema.org/draft-04/schema#";
    public static final String JSON_SCHEMA_IDENTIFIER_ELEMENT = "$schema";

    public static void validateRequest(String json) throws IOException, ProcessingException {
        JsonValidationUtils.validate(json, "/schema/request-schema.json");
    }

    public static void validateRequestItem(String json) throws IOException, ProcessingException {
        JsonValidationUtils.validate(json, "/schema/request-item-schema.json");
    }

    public static void validateResponse(String json) throws IOException, ProcessingException {
        JsonValidationUtils.validate(json, "/schema/response-schema.json");
    }

    public static void validateMappingItem(String json) throws IOException, ProcessingException {
        JsonValidationUtils.validate(json, "/schema/mapping-item-schema.json");
    }

    private static void validate(String json, String schemaPath) throws IOException, ProcessingException {
        try (Scanner scanner = new Scanner(JsonMarshallingUtils.class.getResourceAsStream(schemaPath), "UTF-8");){
            String schema = scanner.useDelimiter("\\A").next();
            JsonValidationUtils.validateJson(schema, json);
        }
    }

    private static JsonNode getJsonNode(String jsonText) throws IOException {
        return JsonLoader.fromString((String)jsonText);
    }

    private static JsonSchema getSchemaNode(String schemaText) throws IOException, ProcessingException {
        JsonNode schemaNode = JsonValidationUtils.getJsonNode(schemaText);
        return JsonValidationUtils.getSchemaNode(schemaNode);
    }

    private static void validateJson(JsonSchema jsonSchemaNode, JsonNode jsonNode) throws ProcessingException {
        Iterator iterator;
        ProcessingReport report = jsonSchemaNode.validate(jsonNode);
        if (!report.isSuccess() && (iterator = report.iterator()).hasNext()) {
            ProcessingMessage processingMessage = (ProcessingMessage)iterator.next();
            throw new ProcessingException(processingMessage);
        }
    }

    private static boolean isJsonValid(JsonSchema jsonSchemaNode, JsonNode jsonNode) throws ProcessingException {
        ProcessingReport report = jsonSchemaNode.validate(jsonNode);
        return report.isSuccess();
    }

    private static void validateJson(String schemaText, String jsonText) throws IOException, ProcessingException {
        JsonSchema schemaNode = JsonValidationUtils.getSchemaNode(schemaText);
        JsonNode jsonNode = JsonValidationUtils.getJsonNode(jsonText);
        JsonValidationUtils.validateJson(schemaNode, jsonNode);
    }

    private static JsonSchema getSchemaNode(JsonNode jsonNode) throws ProcessingException {
        JsonNode schemaIdentifier = jsonNode.get(JSON_SCHEMA_IDENTIFIER_ELEMENT);
        if (null == schemaIdentifier) {
            ((ObjectNode)jsonNode).put(JSON_SCHEMA_IDENTIFIER_ELEMENT, JSON_V4_SCHEMA_IDENTIFIER);
        }
        JsonSchemaFactory factory = JsonSchemaFactory.byDefault();
        return factory.getJsonSchema(jsonNode);
    }
}

