/*
 * Decompiled with CFR 0.152.
 */
package space.glome.http.schema.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.ListIterator;
import java.util.Scanner;
import space.glome.http.schema.domain.Certificate;
import space.glome.http.schema.domain.FileRequestBody;
import space.glome.http.schema.domain.FormDataRequestBody;
import space.glome.http.schema.domain.Header;
import space.glome.http.schema.domain.Proxy;
import space.glome.http.schema.domain.RawRequestBody;
import space.glome.http.schema.domain.RequestBody;
import space.glome.http.schema.domain.URL;
import space.glome.http.schema.domain.UrlEncodedRequestBody;
import space.glome.schema.domain.Argument;
import space.glome.schema.domain.Request;

public class HttpRequest
extends Request {
    private URL url;
    private Method method;
    private List<Header> headers;
    private RequestBody requestBody;
    private Proxy proxy;
    private Certificate certificate;
    private Integer timeout;

    protected HttpRequest() {
    }

    public HttpRequest(URL url, Method method) {
        this.url = url;
        this.method = method;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(Certificate certificate) {
        this.certificate = certificate;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Header> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<Header> headers) {
        this.headers = headers;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public RequestBody getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(RequestBody body) {
        this.requestBody = body;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void removeHeader(String string) {
        ListIterator<Header> iterator = this.headers.listIterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getKey().equals(string)) continue;
            iterator.remove();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JsonIgnore
    public byte[] getPayload() {
        if (this.requestBody == null) {
            return new byte[0];
        }
        if (this.requestBody instanceof RawRequestBody) {
            return ((RawRequestBody)this.requestBody).getRaw().getBytes();
        }
        if (this.requestBody instanceof FileRequestBody) {
            try (Scanner scanner = new Scanner(new File(((FileRequestBody)this.requestBody).getFilePath()));){
                String fileContent = scanner.useDelimiter("\\Z").next();
                for (Argument argument : this.getArguments()) {
                    fileContent = fileContent.replace("${" + argument.getKey() + "}", argument.getValue());
                }
                Object object = fileContent.getBytes();
                return object;
            }
            catch (FileNotFoundException e) {
                throw new Error("Can't load body file", e);
            }
        }
        if (this.requestBody instanceof FormDataRequestBody) {
            throw new Error("Converter for FormDataRequestBody is not implemented yet");
        }
        if (!(this.requestBody instanceof UrlEncodedRequestBody)) throw new Error("Converter for " + ((Object)((Object)this)).getClass().getSimpleName() + " is not implemented");
        throw new Error("Converter for UrlEncodedRequestBody is not implemented yet");
    }

    public static enum Method {
        GET,
        PUT,
        POST,
        PATCH,
        DELETE,
        COPY,
        HEAD,
        OPTIONS,
        LINK,
        UNLINK,
        PURGE,
        LOCK,
        UNLOCK,
        PROPFIND,
        VIEW;

    }
}

