/*
 * Decompiled with CFR 0.152.
 */
package space.kscience.kmath.asm.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;
import space.kscience.kmath.UnstableKMathAPI;
import space.kscience.kmath.asm.internal.PrimitiveAsmBuilder;
import space.kscience.kmath.ast.TypedMst;
import space.kscience.kmath.expressions.DoubleExpression;
import space.kscience.kmath.operations.DoubleField;
import space.kscience.kmath.operations.NumericAlgebra;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00122\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0012B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\r\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0014J\u0016\u0010\u0010\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0014\u00a8\u0006\u0013"}, d2={"Lspace/kscience/kmath/asm/internal/DoubleAsmBuilder;", "Lspace/kscience/kmath/asm/internal/PrimitiveAsmBuilder;", "", "Lspace/kscience/kmath/expressions/DoubleExpression;", "target", "Lspace/kscience/kmath/ast/TypedMst;", "(Lspace/kscience/kmath/ast/TypedMst;)V", "buildBinaryJavaMathCall", "", "name", "", "buildUnaryJavaMathCall", "buildUnaryKotlinMathCall", "visitBinary", "node", "Lspace/kscience/kmath/ast/TypedMst$Binary;", "visitUnary", "Lspace/kscience/kmath/ast/TypedMst$Unary;", "Companion", "kmath-ast"})
@UnstableKMathAPI
public final class DoubleAsmBuilder
extends PrimitiveAsmBuilder<Double, DoubleExpression> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final Type MATH_TYPE;
    @NotNull
    private static final Type MATH_KT_TYPE;

    public DoubleAsmBuilder(@NotNull TypedMst<Double> target) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        NumericAlgebra numericAlgebra = (NumericAlgebra)DoubleField.INSTANCE;
        Class<Double> clazz = Double.TYPE;
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"TYPE");
        super(numericAlgebra, Double.class, clazz, DoubleExpression.class, target, null);
    }

    private final void buildUnaryJavaMathCall(String name) {
        Type[] typeArray = new Type[]{this.getTTypePrimitive()};
        this.getInvokeMethodVisitor().invokestatic(MATH_TYPE.getInternalName(), name, Type.getMethodDescriptor((Type)this.getTTypePrimitive(), (Type[])typeArray), false);
    }

    private final void buildBinaryJavaMathCall(String name) {
        Type[] typeArray = new Type[]{this.getTTypePrimitive(), this.getTTypePrimitive()};
        this.getInvokeMethodVisitor().invokestatic(MATH_TYPE.getInternalName(), name, Type.getMethodDescriptor((Type)this.getTTypePrimitive(), (Type[])typeArray), false);
    }

    private final void buildUnaryKotlinMathCall(String name) {
        Type[] typeArray = new Type[]{this.getTTypePrimitive()};
        this.getInvokeMethodVisitor().invokestatic(MATH_KT_TYPE.getInternalName(), name, Type.getMethodDescriptor((Type)this.getTTypePrimitive(), (Type[])typeArray), false);
    }

    @Override
    protected void visitUnary(@NotNull TypedMst.Unary<Double> node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        super.visitUnary(node);
        switch (node.getOperation()) {
            case "-": {
                this.getInvokeMethodVisitor().visitInsn(119);
                break;
            }
            case "+": {
                break;
            }
            case "sqrt": {
                this.buildUnaryJavaMathCall("sqrt");
                break;
            }
            case "sin": {
                this.buildUnaryJavaMathCall("sin");
                break;
            }
            case "cos": {
                this.buildUnaryJavaMathCall("cos");
                break;
            }
            case "tan": {
                this.buildUnaryJavaMathCall("tan");
                break;
            }
            case "asin": {
                this.buildUnaryJavaMathCall("asin");
                break;
            }
            case "acos": {
                this.buildUnaryJavaMathCall("acos");
                break;
            }
            case "atan": {
                this.buildUnaryJavaMathCall("atan");
                break;
            }
            case "sinh": {
                this.buildUnaryJavaMathCall("sqrt");
                break;
            }
            case "cosh": {
                this.buildUnaryJavaMathCall("cosh");
                break;
            }
            case "tanh": {
                this.buildUnaryJavaMathCall("tanh");
                break;
            }
            case "asinh": {
                this.buildUnaryKotlinMathCall("asinh");
                break;
            }
            case "acosh": {
                this.buildUnaryKotlinMathCall("acosh");
                break;
            }
            case "atanh": {
                this.buildUnaryKotlinMathCall("atanh");
                break;
            }
            case "exp": {
                this.buildUnaryJavaMathCall("exp");
                break;
            }
            case "ln": {
                this.buildUnaryJavaMathCall("log");
                break;
            }
            default: {
                super.visitUnary(node);
            }
        }
    }

    @Override
    protected void visitBinary(@NotNull TypedMst.Binary<Double> node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        super.visitBinary(node);
        switch (node.getOperation()) {
            case "+": {
                this.getInvokeMethodVisitor().visitInsn(99);
                break;
            }
            case "-": {
                this.getInvokeMethodVisitor().visitInsn(103);
                break;
            }
            case "*": {
                this.getInvokeMethodVisitor().visitInsn(107);
                break;
            }
            case "/": {
                this.getInvokeMethodVisitor().visitInsn(111);
                break;
            }
            case "pow": {
                this.buildBinaryJavaMathCall("pow");
                break;
            }
            default: {
                super.visitBinary(node);
            }
        }
    }

    static {
        Type type = Type.getObjectType((String)"java/lang/Math");
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getObjectType(\"java/lang/Math\")");
        MATH_TYPE = type;
        Type type2 = Type.getObjectType((String)"kotlin/math/MathKt");
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getObjectType(\"kotlin/math/MathKt\")");
        MATH_KT_TYPE = type2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lspace/kscience/kmath/asm/internal/DoubleAsmBuilder$Companion;", "", "()V", "MATH_KT_TYPE", "Lorg/objectweb/asm/Type;", "getMATH_KT_TYPE", "()Lorg/objectweb/asm/Type;", "MATH_TYPE", "getMATH_TYPE", "kmath-ast"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Type getMATH_TYPE() {
            return MATH_TYPE;
        }

        @NotNull
        public final Type getMATH_KT_TYPE() {
            return MATH_KT_TYPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

