/*
 * Decompiled with CFR 0.152.
 */
package space.kscience.kmath.ast.rendering;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import space.kscience.kmath.ast.rendering.BinaryMinusSyntax;
import space.kscience.kmath.ast.rendering.BinaryOperatorSyntax;
import space.kscience.kmath.ast.rendering.BinaryPlusSyntax;
import space.kscience.kmath.ast.rendering.ExponentSyntax;
import space.kscience.kmath.ast.rendering.FractionSyntax;
import space.kscience.kmath.ast.rendering.MathSyntax;
import space.kscience.kmath.ast.rendering.MultiplicationSyntax;
import space.kscience.kmath.ast.rendering.NumberSyntax;
import space.kscience.kmath.ast.rendering.OperandSyntax;
import space.kscience.kmath.ast.rendering.OperatorNameSyntax;
import space.kscience.kmath.ast.rendering.RadicalSyntax;
import space.kscience.kmath.ast.rendering.RadicalWithIndexSyntax;
import space.kscience.kmath.ast.rendering.SpecialSymbolSyntax;
import space.kscience.kmath.ast.rendering.SubscriptSyntax;
import space.kscience.kmath.ast.rendering.SuperscriptSyntax;
import space.kscience.kmath.ast.rendering.SymbolSyntax;
import space.kscience.kmath.ast.rendering.SyntaxRenderer;
import space.kscience.kmath.ast.rendering.UnaryMinusSyntax;
import space.kscience.kmath.ast.rendering.UnaryOperatorSyntax;
import space.kscience.kmath.ast.rendering.UnaryPlusSyntax;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\tH\u0016\u00a8\u0006\n"}, d2={"Lspace/kscience/kmath/ast/rendering/LatexSyntaxRenderer;", "Lspace/kscience/kmath/ast/rendering/SyntaxRenderer;", "()V", "render", "", "node", "Lspace/kscience/kmath/ast/rendering/MathSyntax;", "output", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "kmath-ast"})
public final class LatexSyntaxRenderer
implements SyntaxRenderer {
    @NotNull
    public static final LatexSyntaxRenderer INSTANCE = new LatexSyntaxRenderer();

    private LatexSyntaxRenderer() {
    }

    @Override
    public void render(@NotNull MathSyntax node, @NotNull Appendable output) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Appendable $this$render_u24lambda_u240 = output;
        boolean bl = false;
        MathSyntax mathSyntax = node;
        if (mathSyntax instanceof NumberSyntax) {
            $this$render_u24lambda_u240.append(((NumberSyntax)node).getString());
        } else if (mathSyntax instanceof SymbolSyntax) {
            $this$render_u24lambda_u240.append(((SymbolSyntax)node).getString());
        } else if (mathSyntax instanceof OperatorNameSyntax) {
            $this$render_u24lambda_u240.append("\\operatorname{");
            $this$render_u24lambda_u240.append(((OperatorNameSyntax)node).getName());
            $this$render_u24lambda_u240.append('}');
        } else if (mathSyntax instanceof SpecialSymbolSyntax) {
            switch (WhenMappings.$EnumSwitchMapping$0[((SpecialSymbolSyntax)node).getKind().ordinal()]) {
                case 1: {
                    $this$render_u24lambda_u240.append("\\infty");
                    break;
                }
                case 2: {
                    $this$render_u24lambda_u240.append("\\pi");
                }
            }
        } else if (mathSyntax instanceof OperandSyntax) {
            if (((OperandSyntax)node).getParentheses()) {
                $this$render_u24lambda_u240.append("\\left(");
            }
            LatexSyntaxRenderer.render$lambda$0$render(output, ((OperandSyntax)node).getOperand());
            if (((OperandSyntax)node).getParentheses()) {
                $this$render_u24lambda_u240.append("\\right)");
            }
        } else if (mathSyntax instanceof UnaryOperatorSyntax) {
            LatexSyntaxRenderer.render$lambda$0$render(output, ((UnaryOperatorSyntax)node).getPrefix());
            $this$render_u24lambda_u240.append("\\,");
            LatexSyntaxRenderer.render$lambda$0$render(output, ((UnaryOperatorSyntax)node).getOperand());
        } else if (mathSyntax instanceof UnaryPlusSyntax) {
            $this$render_u24lambda_u240.append('+');
            LatexSyntaxRenderer.render$lambda$0$render(output, ((UnaryPlusSyntax)node).getOperand());
        } else if (mathSyntax instanceof UnaryMinusSyntax) {
            $this$render_u24lambda_u240.append('-');
            LatexSyntaxRenderer.render$lambda$0$render(output, ((UnaryMinusSyntax)node).getOperand());
        } else if (mathSyntax instanceof RadicalSyntax) {
            $this$render_u24lambda_u240.append("\\sqrt");
            $this$render_u24lambda_u240.append('{');
            LatexSyntaxRenderer.render$lambda$0$render(output, ((RadicalSyntax)node).getOperand());
            $this$render_u24lambda_u240.append('}');
        } else if (mathSyntax instanceof ExponentSyntax) {
            if (((ExponentSyntax)node).getUseOperatorForm()) {
                $this$render_u24lambda_u240.append("\\operatorname{exp}\\,");
                LatexSyntaxRenderer.render$lambda$0$render(output, ((ExponentSyntax)node).getOperand());
            } else {
                $this$render_u24lambda_u240.append("e^{");
                LatexSyntaxRenderer.render$lambda$0$render(output, ((ExponentSyntax)node).getOperand());
                $this$render_u24lambda_u240.append('}');
            }
        } else if (mathSyntax instanceof SuperscriptSyntax) {
            LatexSyntaxRenderer.render$lambda$0$render(output, ((SuperscriptSyntax)node).getLeft());
            $this$render_u24lambda_u240.append("^{");
            LatexSyntaxRenderer.render$lambda$0$render(output, ((SuperscriptSyntax)node).getRight());
            $this$render_u24lambda_u240.append('}');
        } else if (mathSyntax instanceof SubscriptSyntax) {
            LatexSyntaxRenderer.render$lambda$0$render(output, ((SubscriptSyntax)node).getLeft());
            $this$render_u24lambda_u240.append("_{");
            LatexSyntaxRenderer.render$lambda$0$render(output, ((SubscriptSyntax)node).getRight());
            $this$render_u24lambda_u240.append('}');
        } else if (mathSyntax instanceof BinaryOperatorSyntax) {
            LatexSyntaxRenderer.render$lambda$0$render(output, ((BinaryOperatorSyntax)node).getPrefix());
            $this$render_u24lambda_u240.append("\\left(");
            LatexSyntaxRenderer.render$lambda$0$render(output, ((BinaryOperatorSyntax)node).getLeft());
            $this$render_u24lambda_u240.append(',');
            LatexSyntaxRenderer.render$lambda$0$render(output, ((BinaryOperatorSyntax)node).getRight());
            $this$render_u24lambda_u240.append("\\right)");
        } else if (mathSyntax instanceof BinaryPlusSyntax) {
            LatexSyntaxRenderer.render$lambda$0$render(output, ((BinaryPlusSyntax)node).getLeft());
            $this$render_u24lambda_u240.append('+');
            LatexSyntaxRenderer.render$lambda$0$render(output, ((BinaryPlusSyntax)node).getRight());
        } else if (mathSyntax instanceof BinaryMinusSyntax) {
            LatexSyntaxRenderer.render$lambda$0$render(output, ((BinaryMinusSyntax)node).getLeft());
            $this$render_u24lambda_u240.append('-');
            LatexSyntaxRenderer.render$lambda$0$render(output, ((BinaryMinusSyntax)node).getRight());
        } else if (mathSyntax instanceof FractionSyntax) {
            if (((FractionSyntax)node).getInfix()) {
                LatexSyntaxRenderer.render$lambda$0$render(output, ((FractionSyntax)node).getLeft());
                $this$render_u24lambda_u240.append('/');
                LatexSyntaxRenderer.render$lambda$0$render(output, ((FractionSyntax)node).getRight());
            } else {
                $this$render_u24lambda_u240.append("\\frac{");
                LatexSyntaxRenderer.render$lambda$0$render(output, ((FractionSyntax)node).getLeft());
                $this$render_u24lambda_u240.append("}{");
                LatexSyntaxRenderer.render$lambda$0$render(output, ((FractionSyntax)node).getRight());
                $this$render_u24lambda_u240.append('}');
            }
        } else if (mathSyntax instanceof RadicalWithIndexSyntax) {
            $this$render_u24lambda_u240.append("\\sqrt");
            $this$render_u24lambda_u240.append('[');
            LatexSyntaxRenderer.render$lambda$0$render(output, ((RadicalWithIndexSyntax)node).getLeft());
            $this$render_u24lambda_u240.append(']');
            $this$render_u24lambda_u240.append('{');
            LatexSyntaxRenderer.render$lambda$0$render(output, ((RadicalWithIndexSyntax)node).getRight());
            $this$render_u24lambda_u240.append('}');
        } else if (mathSyntax instanceof MultiplicationSyntax) {
            LatexSyntaxRenderer.render$lambda$0$render(output, ((MultiplicationSyntax)node).getLeft());
            $this$render_u24lambda_u240.append(((MultiplicationSyntax)node).getTimes() ? "\\times" : "\\,");
            LatexSyntaxRenderer.render$lambda$0$render(output, ((MultiplicationSyntax)node).getRight());
        }
    }

    private static final void render$lambda$0$render(Appendable $output, MathSyntax syntax) {
        INSTANCE.render(syntax, $output);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SpecialSymbolSyntax.Kind.values().length];
            try {
                nArray[SpecialSymbolSyntax.Kind.INFINITY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpecialSymbolSyntax.Kind.SMALL_PI.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

