/*
 * Decompiled with CFR 0.152.
 */
package space.kscience.kmath.ast.rendering;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import space.kscience.kmath.ast.rendering.FeaturedMathRenderer;
import space.kscience.kmath.ast.rendering.FeaturesKt;
import space.kscience.kmath.ast.rendering.MathSyntax;
import space.kscience.kmath.ast.rendering.MultiplatformToStringKt;
import space.kscience.kmath.ast.rendering.MultiplicationSyntax;
import space.kscience.kmath.ast.rendering.NumberSyntax;
import space.kscience.kmath.ast.rendering.OperandSyntax;
import space.kscience.kmath.ast.rendering.SpecialSymbolSyntax;
import space.kscience.kmath.ast.rendering.SuperscriptSyntax;
import space.kscience.kmath.ast.rendering.UnaryMinusSyntax;
import space.kscience.kmath.expressions.MST;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u001b\u0012\u0014\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001f\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lspace/kscience/kmath/ast/rendering/PrettyPrintFloats;", "Lspace/kscience/kmath/ast/rendering/FeaturedMathRenderer$RenderFeature;", "types", "", "Lkotlin/reflect/KClass;", "", "(Ljava/util/Set;)V", "getTypes", "()Ljava/util/Set;", "render", "Lspace/kscience/kmath/ast/rendering/MathSyntax;", "renderer", "Lspace/kscience/kmath/ast/rendering/FeaturedMathRenderer;", "node", "Lspace/kscience/kmath/expressions/MST;", "Companion", "kmath-ast"})
public final class PrettyPrintFloats
implements FeaturedMathRenderer.RenderFeature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<KClass<? extends Number>> types;
    @NotNull
    private static final PrettyPrintFloats Default;

    public PrettyPrintFloats(@NotNull Set<? extends KClass<? extends Number>> types) {
        Intrinsics.checkNotNullParameter(types, (String)"types");
        this.types = types;
    }

    @NotNull
    public final Set<KClass<? extends Number>> getTypes() {
        return this.types;
    }

    @Override
    @Nullable
    public MathSyntax render(@NotNull FeaturedMathRenderer renderer, @NotNull MST node) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!(node instanceof MST.Numeric) || !this.types.contains(Reflection.getOrCreateKotlinClass(((MST.Numeric)node).getValue().getClass()))) {
            return null;
        }
        Object v = ((MST.Numeric)node).getValue();
        String toString = StringsKt.removeSuffix((String)(v instanceof Float ? MultiplatformToStringKt.multiplatformToString(((Number)v).floatValue()) : (v instanceof Double ? MultiplatformToStringKt.multiplatformToString(((Number)v).doubleValue()) : v.toString())), (CharSequence)".0");
        if (StringsKt.contains((CharSequence)toString, (char)'E', (boolean)true)) {
            char[] cArray = new char[]{'E'};
            v = StringsKt.split$default((CharSequence)toString, (char[])cArray, (boolean)true, (int)0, (int)4, null);
            String beforeE = (String)v.get(0);
            String afterE = (String)v.get(1);
            String significand = StringsKt.removeSuffix((String)String.valueOf(Double.parseDouble(beforeE)), (CharSequence)".0");
            String exponent = StringsKt.removeSuffix((String)String.valueOf(Double.parseDouble(afterE)), (CharSequence)".0");
            return new MultiplicationSyntax("*", new OperandSyntax(new NumberSyntax(significand), true), new OperandSyntax(new SuperscriptSyntax("pow", new NumberSyntax("10"), FeaturesKt.access$printSignedNumberString(exponent)), true), true);
        }
        if (StringsKt.endsWith$default((String)toString, (String)"Infinity", (boolean)false, (int)2, null)) {
            SpecialSymbolSyntax infty = new SpecialSymbolSyntax(SpecialSymbolSyntax.Kind.INFINITY);
            if (StringsKt.startsWith$default((CharSequence)toString, (char)'-', (boolean)false, (int)2, null)) {
                return new UnaryMinusSyntax("-", new OperandSyntax(infty, true));
            }
            return infty;
        }
        return FeaturesKt.access$printSignedNumberString(toString);
    }

    static {
        Object[] objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(Float.TYPE), Reflection.getOrCreateKotlinClass(Double.TYPE)};
        Default = new PrettyPrintFloats(SetsKt.setOf((Object[])objectArray));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lspace/kscience/kmath/ast/rendering/PrettyPrintFloats$Companion;", "", "()V", "Default", "Lspace/kscience/kmath/ast/rendering/PrettyPrintFloats;", "getDefault", "()Lspace/kscience/kmath/ast/rendering/PrettyPrintFloats;", "kmath-ast"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PrettyPrintFloats getDefault() {
            return Default;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

