/*
 * Decompiled with CFR 0.152.
 */
package space.kscience.kmath.complex;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import space.kscience.kmath.memory.MemoryReader;
import space.kscience.kmath.memory.MemorySpec;
import space.kscience.kmath.memory.MemoryWriter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\f\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0007H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00072\b\b\u0002\u0010\u0004\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0004\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0017"}, d2={"Lspace/kscience/kmath/complex/Complex;", "", "re", "", "im", "(Ljava/lang/Number;Ljava/lang/Number;)V", "(Ljava/lang/Number;)V", "", "(DD)V", "getIm", "()D", "getRe", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "kmath-complex"})
public final class Complex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double re;
    private final double im;

    public Complex(double re, double im) {
        this.re = re;
        this.im = im;
    }

    public final double getRe() {
        return this.re;
    }

    public final double getIm() {
        return this.im;
    }

    public Complex(@NotNull Number re, @NotNull Number im) {
        Intrinsics.checkNotNullParameter((Object)re, (String)"re");
        Intrinsics.checkNotNullParameter((Object)im, (String)"im");
        this(re.doubleValue(), im.doubleValue());
    }

    public Complex(@NotNull Number re) {
        Intrinsics.checkNotNullParameter((Object)re, (String)"re");
        this(re.doubleValue(), 0.0);
    }

    @NotNull
    public String toString() {
        return "(" + this.re + " + i * " + this.im + ")";
    }

    public final double component1() {
        return this.re;
    }

    public final double component2() {
        return this.im;
    }

    @NotNull
    public final Complex copy(double re, double im) {
        return new Complex(re, im);
    }

    public static /* synthetic */ Complex copy$default(Complex complex, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = complex.re;
        }
        if ((n & 2) != 0) {
            d2 = complex.im;
        }
        return complex.copy(d, d2);
    }

    public int hashCode() {
        int result = Double.hashCode(this.re);
        result = result * 31 + Double.hashCode(this.im);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Complex)) {
            return false;
        }
        Complex complex = (Complex)other;
        if (Double.compare(this.re, complex.re) != 0) {
            return false;
        }
        return Double.compare(this.im, complex.im) == 0;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\b\u001a\u00020\u0002*\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u001c\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lspace/kscience/kmath/complex/Complex$Companion;", "Lspace/kscience/kmath/memory/MemorySpec;", "Lspace/kscience/kmath/complex/Complex;", "()V", "objectSize", "", "getObjectSize", "()I", "read", "Lspace/kscience/kmath/memory/MemoryReader;", "offset", "write", "", "Lspace/kscience/kmath/memory/MemoryWriter;", "value", "kmath-complex"})
    public static final class Companion
    implements MemorySpec<Complex> {
        private Companion() {
        }

        public int getObjectSize() {
            return 16;
        }

        @NotNull
        public Complex read(@NotNull MemoryReader $this$read, int offset) {
            Intrinsics.checkNotNullParameter((Object)$this$read, (String)"<this>");
            return new Complex($this$read.readDouble(offset), $this$read.readDouble(offset + 8));
        }

        public void write(@NotNull MemoryWriter $this$write, int offset, @NotNull Complex value) {
            Intrinsics.checkNotNullParameter((Object)$this$write, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            $this$write.writeDouble(offset, value.getRe());
            $this$write.writeDouble(offset + 8, value.getIm());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

