/*
 * Decompiled with CFR 0.152.
 */
package space.kscience.kmath.complex;

import java.util.Iterator;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import space.kscience.kmath.complex.Complex;
import space.kscience.kmath.complex.ComplexKt;
import space.kscience.kmath.memory.ByteBufferMemoryKt;
import space.kscience.kmath.memory.Memory;
import space.kscience.kmath.memory.MemorySpec;
import space.kscience.kmath.operations.ExtendedField;
import space.kscience.kmath.operations.Norm;
import space.kscience.kmath.operations.NumbersAddOps;
import space.kscience.kmath.operations.ScaleOperations;
import space.kscience.kmath.structures.MutableBuffer;
import space.kscience.kmath.structures.MutableBufferFactory;
import space.kscience.kmath.structures.MutableMemoryBuffer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00032\b\u0012\u0004\u0012\u00020\u00020\u00042\b\u0012\u0004\u0012\u00020\u00020\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0018\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0010\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J@\u0010\u001b\u001a2\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\u00022\u0006\u0010\"\u001a\u00020 H\u0016J\u0010\u0010#\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0018\u0010$\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\u0010\u0010%\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0010\u0010&\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0018\u0010'\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\u0010\u0010(\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0010\u0010)\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020*H\u0016J\u0018\u0010+\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010,\u001a\u00020*H\u0016J\u0016\u0010+\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010,\u001a\u00020\u0002J\u0018\u0010-\u001a\u00020\u00022\u0006\u0010.\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0010\u00101\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0015\u00102\u001a\u00020\u0002*\u00020\u00022\u0006\u00103\u001a\u00020*H\u0096\u0002J\u0015\u00104\u001a\u00020\u0002*\u00020/2\u0006\u00105\u001a\u00020\u0002H\u0086\u0002J\u0015\u00104\u001a\u00020\u0002*\u00020\u00022\u0006\u00106\u001a\u00020/H\u0086\u0002J\u0015\u00107\u001a\u00020\u0002*\u00020/2\u0006\u00105\u001a\u00020\u0002H\u0086\u0002J\u0015\u00107\u001a\u00020\u0002*\u00020\u00022\u0006\u00106\u001a\u00020/H\u0086\u0002J\u0015\u00108\u001a\u00020\u0002*\u00020/2\u0006\u00105\u001a\u00020\u0002H\u0086\u0002J\r\u00109\u001a\u00020\u0002*\u00020\u0002H\u0096\u0002R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\u00028FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0014\u0010\u0012\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\r\u00a8\u0006:"}, d2={"Lspace/kscience/kmath/complex/ComplexField;", "Lspace/kscience/kmath/operations/ExtendedField;", "Lspace/kscience/kmath/complex/Complex;", "Lspace/kscience/kmath/operations/Norm;", "Lspace/kscience/kmath/operations/NumbersAddOps;", "Lspace/kscience/kmath/operations/ScaleOperations;", "()V", "bufferFactory", "Lspace/kscience/kmath/structures/MutableBufferFactory;", "getBufferFactory", "()Lspace/kscience/kmath/structures/MutableBufferFactory;", "i", "getI", "()Lspace/kscience/kmath/complex/Complex;", "i$delegate", "Lkotlin/Lazy;", "one", "getOne", "zero", "getZero", "acos", "arg", "add", "left", "right", "asin", "atan", "binaryOperationFunction", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "operation", "", "bindSymbolOrNull", "value", "cos", "divide", "exp", "ln", "multiply", "norm", "number", "", "power", "pow", "scale", "a", "", "sin", "tan", "div", "k", "minus", "c", "d", "plus", "times", "unaryMinus", "kmath-complex"})
@SourceDebugExtension(value={"SMAP\nComplex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Complex.kt\nspace/kscience/kmath/complex/ComplexField\n+ 2 MemoryBuffer.kt\nspace/kscience/kmath/structures/MutableMemoryBuffer$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,241:1\n62#2,2:242\n64#2:246\n1855#3,2:244\n*S KotlinDebug\n*F\n+ 1 Complex.kt\nspace/kscience/kmath/complex/ComplexField\n*L\n55#1:242,2\n55#1:246\n55#1:244,2\n*E\n"})
public final class ComplexField
implements ExtendedField<Complex>,
Norm<Complex, Complex>,
NumbersAddOps<Complex>,
ScaleOperations<Complex> {
    @NotNull
    public static final ComplexField INSTANCE = new ComplexField();
    @NotNull
    private static final MutableBufferFactory<Complex> bufferFactory = ComplexField::bufferFactory$lambda$0;
    @NotNull
    private static final Complex zero = ComplexKt.toComplex(0.0);
    @NotNull
    private static final Complex one = ComplexKt.toComplex(1.0);
    @NotNull
    private static final Lazy i$delegate = LazyKt.lazy(ComplexField::i_delegate$lambda$1);

    private ComplexField() {
    }

    @NotNull
    public MutableBufferFactory<Complex> getBufferFactory() {
        return bufferFactory;
    }

    @NotNull
    public Complex getZero() {
        return zero;
    }

    @NotNull
    public Complex getOne() {
        return one;
    }

    @Nullable
    public Complex bindSymbolOrNull(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return Intrinsics.areEqual((Object)value, (Object)"i") ? this.getI() : null;
    }

    @NotNull
    public Function2<Complex, Complex, Complex> binaryOperationFunction(@NotNull String operation) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        return Intrinsics.areEqual((Object)operation, (Object)"pow") ? (Function2)new Function2<Complex, Complex, Complex>((Object)INSTANCE){

            @NotNull
            public final Complex invoke(@NotNull Complex p0, @NotNull Complex p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((ComplexField)this.receiver).power(p0, p1);
            }
        } : super.binaryOperationFunction(operation);
    }

    @NotNull
    public final Complex getI() {
        Lazy lazy = i$delegate;
        return (Complex)lazy.getValue();
    }

    @NotNull
    public Complex unaryMinus(@NotNull Complex $this$unaryMinus) {
        Intrinsics.checkNotNullParameter((Object)$this$unaryMinus, (String)"<this>");
        return new Complex(-$this$unaryMinus.getRe(), -$this$unaryMinus.getIm());
    }

    @NotNull
    public Complex number(@NotNull Number value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new Complex(value.doubleValue(), 0.0);
    }

    @NotNull
    public Complex scale(@NotNull Complex a, double value) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        return new Complex(a.getRe() * value, a.getIm() * value);
    }

    @NotNull
    public Complex add(@NotNull Complex left, @NotNull Complex right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return new Complex(left.getRe() + right.getRe(), left.getIm() + right.getIm());
    }

    @NotNull
    public Complex multiply(@NotNull Complex left, @NotNull Complex right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return new Complex(left.getRe() * right.getRe() - left.getIm() * right.getIm(), left.getRe() * right.getIm() + left.getIm() * right.getRe());
    }

    @NotNull
    public Complex divide(@NotNull Complex left, @NotNull Complex right) {
        Complex complex;
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        if (Math.abs(right.getIm()) < Math.abs(right.getRe())) {
            double wr = right.getIm() / right.getRe();
            double wd = right.getRe() + wr * right.getIm();
            if (Double.isNaN(wd) || wd == 0.0) {
                throw new ArithmeticException("Division by zero or infinity");
            }
            complex = new Complex((left.getRe() + left.getIm() * wr) / wd, (left.getIm() - left.getRe() * wr) / wd);
        } else {
            if (right.getIm() == 0.0) {
                throw new ArithmeticException("Division by zero");
            }
            double wr = right.getRe() / right.getIm();
            double wd = right.getIm() + wr * right.getRe();
            if (Double.isNaN(wd) || wd == 0.0) {
                throw new ArithmeticException("Division by zero or infinity");
            }
            complex = new Complex((left.getRe() * wr + left.getIm()) / wd, (left.getIm() * wr - left.getRe()) / wd);
        }
        return complex;
    }

    @NotNull
    public Complex div(@NotNull Complex $this$div, @NotNull Number k) {
        Intrinsics.checkNotNullParameter((Object)$this$div, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)k, (String)"k");
        return new Complex($this$div.getRe() / k.doubleValue(), $this$div.getIm() / k.doubleValue());
    }

    @NotNull
    public Complex sin(@NotNull Complex arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        return this.div((Complex)this.times(this.getI(), this.minus(this.exp((Complex)this.times(this.unaryMinus(this.getI()), arg)), this.exp((Complex)this.times(this.getI(), arg)))), (Number)2.0);
    }

    @NotNull
    public Complex cos(@NotNull Complex arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        return this.div((Complex)this.plus(this.exp((Complex)this.times(this.unaryMinus(this.getI()), arg)), this.exp((Complex)this.times(this.getI(), arg))), (Number)2.0);
    }

    @NotNull
    public Complex tan(@NotNull Complex arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        Complex e1 = this.exp((Complex)this.times(this.unaryMinus(this.getI()), arg));
        Complex e2 = this.exp((Complex)this.times(this.getI(), arg));
        return (Complex)this.div(this.times(this.getI(), this.minus(e1, e2)), this.plus(e1, e2));
    }

    @NotNull
    public Complex asin(@NotNull Complex arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        return (Complex)this.times(this.unaryMinus(this.getI()), this.ln((Complex)this.plus(this.sqrt(this.minus(1, this.times(arg, arg))), this.times(this.getI(), arg))));
    }

    @NotNull
    public Complex acos(@NotNull Complex arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        return (Complex)this.plus(ComplexKt.access$getPI_DIV_2$p(), this.times(this.getI(), this.ln((Complex)this.plus(this.sqrt(this.minus(1, this.times(arg, arg))), this.times(this.getI(), arg)))));
    }

    @NotNull
    public Complex atan(@NotNull Complex arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        Complex iArg = (Complex)this.times(this.getI(), arg);
        return this.div((Complex)this.times(this.getI(), this.minus(this.ln((Complex)this.minus(1, iArg)), this.ln((Complex)this.plus(1, iArg)))), (Number)2);
    }

    @NotNull
    public Complex power(@NotNull Complex arg, @NotNull Number pow) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        Intrinsics.checkNotNullParameter((Object)pow, (String)"pow");
        return arg.getIm() == 0.0 ? ComplexKt.toComplex(Math.pow(arg.getRe(), pow.doubleValue())) : this.exp((Complex)this.times(pow, this.ln(arg)));
    }

    @NotNull
    public final Complex power(@NotNull Complex arg, @NotNull Complex pow) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        Intrinsics.checkNotNullParameter((Object)pow, (String)"pow");
        return this.exp((Complex)this.times(pow, this.ln(arg)));
    }

    @NotNull
    public Complex exp(@NotNull Complex arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        return this.times(Math.exp(arg.getRe()), this.plus(Math.cos(arg.getIm()), (Complex)this.times(this.getI(), Math.sin(arg.getIm()))));
    }

    @NotNull
    public Complex ln(@NotNull Complex arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        return this.plus(Math.log(ComplexKt.getR(arg)), (Complex)this.times(this.getI(), Math.atan2(arg.getIm(), arg.getRe())));
    }

    @NotNull
    public final Complex plus(double $this$plus, @NotNull Complex c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return this.add(ComplexKt.toComplex($this$plus), c);
    }

    @NotNull
    public final Complex minus(double $this$minus, @NotNull Complex c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return this.add(ComplexKt.toComplex($this$minus), this.unaryMinus(c));
    }

    @NotNull
    public final Complex plus(@NotNull Complex $this$plus, double d) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        return this.plus(d, $this$plus);
    }

    @NotNull
    public final Complex minus(@NotNull Complex $this$minus, double d) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        return this.add($this$minus, this.unaryMinus(ComplexKt.toComplex(d)));
    }

    @NotNull
    public final Complex times(double $this$times, @NotNull Complex c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return new Complex(c.getRe() * $this$times, c.getIm() * $this$times);
    }

    @NotNull
    public Complex norm(@NotNull Complex arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        return (Complex)this.sqrt(this.times(ComplexKt.getConjugate(arg), arg));
    }

    private static final MutableBuffer bufferFactory$lambda$0(int size, Function1 init) {
        MutableMemoryBuffer mutableMemoryBuffer;
        Intrinsics.checkNotNullParameter((Object)init, (String)"init");
        MutableMemoryBuffer.Companion companion = MutableMemoryBuffer.Companion;
        MemorySpec spec$iv = Complex.Companion;
        boolean $i$f$create = false;
        MutableMemoryBuffer buffer$iv = mutableMemoryBuffer = new MutableMemoryBuffer(ByteBufferMemoryKt.allocate((Memory.Companion)Memory.Companion, (int)(size * spec$iv.getObjectSize())), spec$iv);
        boolean bl = false;
        Iterable $this$forEach$iv$iv = (Iterable)RangesKt.until((int)0, (int)size);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv$iv;
            int it$iv = element$iv$iv = ((IntIterator)iterator).nextInt();
            boolean bl2 = false;
            buffer$iv.set(it$iv, init.invoke((Object)it$iv));
        }
        return (MutableBuffer)mutableMemoryBuffer;
    }

    private static final Complex i_delegate$lambda$1() {
        return new Complex(0.0, 1.0);
    }
}

