/*
 * Decompiled with CFR 0.152.
 */
package space.kscience.kmath.complex;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import space.kscience.kmath.complex.Complex;
import space.kscience.kmath.complex.ComplexField;
import space.kscience.kmath.memory.ByteBufferMemoryKt;
import space.kscience.kmath.memory.Memory;
import space.kscience.kmath.memory.MemorySpec;
import space.kscience.kmath.structures.Buffer;
import space.kscience.kmath.structures.MemoryBuffer;
import space.kscience.kmath.structures.MutableBuffer;
import space.kscience.kmath.structures.MutableMemoryBuffer;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\u001a2\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00010\u0018H\u0086\b\u00f8\u0001\u0000\u001a2\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u0019*\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00010\u0018H\u0086\b\u00f8\u0001\u0000\u001a\n\u0010\u001b\u001a\u00020\u0001*\u00020\u001c\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0002\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0015\u0010\u0007\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0015\u0010\n\u001a\u00020\u000b*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0015\u0010\u000e\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\t\"\u0015\u0010\u0010\u001a\u00020\u000b*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\r\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001d"}, d2={"PI_DIV_2", "Lspace/kscience/kmath/complex/Complex;", "algebra", "Lspace/kscience/kmath/complex/ComplexField;", "Lspace/kscience/kmath/complex/Complex$Companion;", "getAlgebra", "(Lspace/kscience/kmath/complex/Complex$Companion;)Lspace/kscience/kmath/complex/ComplexField;", "conjugate", "getConjugate", "(Lspace/kscience/kmath/complex/Complex;)Lspace/kscience/kmath/complex/Complex;", "r", "", "getR", "(Lspace/kscience/kmath/complex/Complex;)D", "reciprocal", "getReciprocal", "theta", "getTheta", "complex", "Lspace/kscience/kmath/structures/Buffer;", "Lspace/kscience/kmath/structures/Buffer$Companion;", "size", "", "init", "Lkotlin/Function1;", "Lspace/kscience/kmath/structures/MutableBuffer;", "Lspace/kscience/kmath/structures/MutableBuffer$Companion;", "toComplex", "", "kmath-complex"})
@SourceDebugExtension(value={"SMAP\nComplex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Complex.kt\nspace/kscience/kmath/complex/ComplexKt\n+ 2 MemoryBuffer.kt\nspace/kscience/kmath/structures/MemoryBuffer$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 MemoryBuffer.kt\nspace/kscience/kmath/structures/MutableMemoryBuffer$Companion\n*L\n1#1,241:1\n33#2,2:242\n35#2:246\n1855#3,2:244\n1855#3,2:249\n62#4,2:247\n64#4:251\n*S KotlinDebug\n*F\n+ 1 Complex.kt\nspace/kscience/kmath/complex/ComplexKt\n*L\n233#1:242,2\n233#1:246\n233#1:244,2\n240#1:249,2\n240#1:247,2\n240#1:251\n*E\n"})
public final class ComplexKt {
    @NotNull
    private static final Complex PI_DIV_2 = new Complex((Number)1.5707963267948966, (Number)0);

    @NotNull
    public static final Complex getConjugate(@NotNull Complex $this$conjugate) {
        Intrinsics.checkNotNullParameter((Object)$this$conjugate, (String)"<this>");
        return new Complex($this$conjugate.getRe(), -$this$conjugate.getIm());
    }

    @NotNull
    public static final Complex getReciprocal(@NotNull Complex $this$reciprocal) {
        Intrinsics.checkNotNullParameter((Object)$this$reciprocal, (String)"<this>");
        double scale = $this$reciprocal.getRe() * $this$reciprocal.getRe() + $this$reciprocal.getIm() * $this$reciprocal.getIm();
        return new Complex($this$reciprocal.getRe() / scale, -$this$reciprocal.getIm() / scale);
    }

    public static final double getR(@NotNull Complex $this$r) {
        Intrinsics.checkNotNullParameter((Object)$this$r, (String)"<this>");
        return Math.sqrt($this$r.getRe() * $this$r.getRe() + $this$r.getIm() * $this$r.getIm());
    }

    public static final double getTheta(@NotNull Complex $this$theta) {
        Intrinsics.checkNotNullParameter((Object)$this$theta, (String)"<this>");
        return Math.atan2($this$theta.getIm(), $this$theta.getRe());
    }

    @NotNull
    public static final ComplexField getAlgebra(@NotNull Complex.Companion $this$algebra) {
        Intrinsics.checkNotNullParameter((Object)$this$algebra, (String)"<this>");
        return ComplexField.INSTANCE;
    }

    @NotNull
    public static final Complex toComplex(@NotNull Number $this$toComplex) {
        Intrinsics.checkNotNullParameter((Object)$this$toComplex, (String)"<this>");
        return new Complex($this$toComplex);
    }

    @NotNull
    public static final Buffer<Complex> complex(@NotNull Buffer.Companion $this$complex, int size, @NotNull Function1<? super Integer, Complex> init) {
        MutableMemoryBuffer mutableMemoryBuffer;
        Intrinsics.checkNotNullParameter((Object)$this$complex, (String)"<this>");
        Intrinsics.checkNotNullParameter(init, (String)"init");
        boolean $i$f$complex = false;
        MemoryBuffer.Companion companion = MemoryBuffer.Companion;
        MemorySpec spec$iv = Complex.Companion;
        boolean $i$f$create = false;
        MutableMemoryBuffer buffer$iv = mutableMemoryBuffer = new MutableMemoryBuffer(ByteBufferMemoryKt.allocate((Memory.Companion)Memory.Companion, (int)(size * spec$iv.getObjectSize())), spec$iv);
        boolean bl = false;
        Iterable $this$forEach$iv$iv = (Iterable)RangesKt.until((int)0, (int)size);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv$iv;
            int it$iv = element$iv$iv = ((IntIterator)iterator).nextInt();
            boolean bl2 = false;
            buffer$iv.set(it$iv, init.invoke((Object)it$iv));
        }
        return (Buffer)((MemoryBuffer)mutableMemoryBuffer);
    }

    @NotNull
    public static final MutableBuffer<Complex> complex(@NotNull MutableBuffer.Companion $this$complex, int size, @NotNull Function1<? super Integer, Complex> init) {
        MutableMemoryBuffer mutableMemoryBuffer;
        Intrinsics.checkNotNullParameter((Object)$this$complex, (String)"<this>");
        Intrinsics.checkNotNullParameter(init, (String)"init");
        boolean $i$f$complex = false;
        MutableMemoryBuffer.Companion companion = MutableMemoryBuffer.Companion;
        MemorySpec spec$iv = Complex.Companion;
        boolean $i$f$create = false;
        MutableMemoryBuffer buffer$iv = mutableMemoryBuffer = new MutableMemoryBuffer(ByteBufferMemoryKt.allocate((Memory.Companion)Memory.Companion, (int)(size * spec$iv.getObjectSize())), spec$iv);
        boolean bl = false;
        Iterable $this$forEach$iv$iv = (Iterable)RangesKt.until((int)0, (int)size);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv$iv;
            int it$iv = element$iv$iv = ((IntIterator)iterator).nextInt();
            boolean bl2 = false;
            buffer$iv.set(it$iv, init.invoke((Object)it$iv));
        }
        return (MutableBuffer)mutableMemoryBuffer;
    }

    public static final /* synthetic */ Complex access$getPI_DIV_2$p() {
        return PI_DIV_2;
    }
}

