/*
 * Decompiled with CFR 0.152.
 */
package space.kscience.kmath.complex;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import space.kscience.kmath.memory.MemoryReader;
import space.kscience.kmath.memory.MemorySpec;
import space.kscience.kmath.memory.MemoryWriter;
import space.kscience.kmath.structures.Buffer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010(\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\u0016\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\tH\u0096\u0002\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\tH\u0016J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u001e"}, d2={"Lspace/kscience/kmath/complex/Quaternion;", "Lspace/kscience/kmath/structures/Buffer;", "", "w", "x", "y", "z", "(DDDD)V", "size", "", "getSize", "()I", "getW", "()D", "getX", "getY", "getZ", "equals", "", "other", "", "get", "index", "(I)Ljava/lang/Double;", "hashCode", "iterator", "", "toString", "", "Companion", "kmath-complex"})
@SourceDebugExtension(value={"SMAP\nQuaternion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Quaternion.kt\nspace/kscience/kmath/complex/Quaternion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,296:1\n1#2:297\n*E\n"})
public final class Quaternion
implements Buffer<Double> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double w;
    private final double x;
    private final double y;
    private final double z;

    public Quaternion(double w, double x, double y, double z) {
        this.w = w;
        this.x = x;
        this.y = y;
        this.z = z;
        if (!(!Double.isNaN(this.w))) {
            boolean $i$a$-require-Quaternion$52 = false;
            String $i$a$-require-Quaternion$52 = "w-component of quaternion is not-a-number";
            throw new IllegalArgumentException($i$a$-require-Quaternion$52.toString());
        }
        if (!(!Double.isNaN(this.x))) {
            boolean $i$a$-require-Quaternion$62 = false;
            String $i$a$-require-Quaternion$62 = "x-component of quaternion is not-a-number";
            throw new IllegalArgumentException($i$a$-require-Quaternion$62.toString());
        }
        if (!(!Double.isNaN(this.y))) {
            boolean $i$a$-require-Quaternion$72 = false;
            String $i$a$-require-Quaternion$72 = "y-component of quaternion is not-a-number";
            throw new IllegalArgumentException($i$a$-require-Quaternion$72.toString());
        }
        if (!(!Double.isNaN(this.z))) {
            boolean bl = false;
            String string = "z-component of quaternion is not-a-number";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final double getW() {
        return this.w;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    @NotNull
    public String toString() {
        return "(" + this.w + " + " + this.x + " * i + " + this.y + " * j + " + this.z + " * k)";
    }

    public int getSize() {
        return 4;
    }

    @NotNull
    public Double get(int index) {
        double d;
        switch (index) {
            case 0: {
                d = this.w;
                break;
            }
            case 1: {
                d = this.x;
                break;
            }
            case 2: {
                d = this.y;
                break;
            }
            case 3: {
                d = this.z;
                break;
            }
            default: {
                throw new IllegalStateException(("Index " + index + " out of bounds [0,3]").toString());
            }
        }
        return d;
    }

    @NotNull
    public Iterator<Double> iterator() {
        Object[] objectArray = new Double[]{this.w, this.x, this.y, this.z};
        return CollectionsKt.listOf((Object[])objectArray).iterator();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Quaternion cfr_ignored_0 = (Quaternion)other;
        if (!(this.w == ((Quaternion)other).w)) {
            return false;
        }
        if (!(this.x == ((Quaternion)other).x)) {
            return false;
        }
        if (!(this.y == ((Quaternion)other).y)) {
            return false;
        }
        return this.z == ((Quaternion)other).z;
    }

    public int hashCode() {
        int result = Double.hashCode(this.w);
        result = 31 * result + Double.hashCode(this.x);
        result = 31 * result + Double.hashCode(this.y);
        result = 31 * result + Double.hashCode(this.z);
        return result;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\b\u001a\u00020\u0002*\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u001c\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lspace/kscience/kmath/complex/Quaternion$Companion;", "Lspace/kscience/kmath/memory/MemorySpec;", "Lspace/kscience/kmath/complex/Quaternion;", "()V", "objectSize", "", "getObjectSize", "()I", "read", "Lspace/kscience/kmath/memory/MemoryReader;", "offset", "write", "", "Lspace/kscience/kmath/memory/MemoryWriter;", "value", "kmath-complex"})
    public static final class Companion
    implements MemorySpec<Quaternion> {
        private Companion() {
        }

        public int getObjectSize() {
            return 32;
        }

        @NotNull
        public Quaternion read(@NotNull MemoryReader $this$read, int offset) {
            Intrinsics.checkNotNullParameter((Object)$this$read, (String)"<this>");
            return new Quaternion($this$read.readDouble(offset), $this$read.readDouble(offset + 8), $this$read.readDouble(offset + 16), $this$read.readDouble(offset + 24));
        }

        public void write(@NotNull MemoryWriter $this$write, int offset, @NotNull Quaternion value) {
            Intrinsics.checkNotNullParameter((Object)$this$write, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            $this$write.writeDouble(offset, value.getW());
            $this$write.writeDouble(offset + 8, value.getX());
            $this$write.writeDouble(offset + 16, value.getY());
            $this$write.writeDouble(offset + 24, value.getZ());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

