/*
 * Decompiled with CFR 0.152.
 */
package space.kscience.kmath.complex;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import space.kscience.kmath.complex.Complex;
import space.kscience.kmath.complex.ComplexField;
import space.kscience.kmath.complex.ComplexKt;
import space.kscience.kmath.complex.Quaternion;
import space.kscience.kmath.complex.QuaternionKt;
import space.kscience.kmath.operations.Algebra;
import space.kscience.kmath.operations.ExponentialOperations;
import space.kscience.kmath.operations.Field;
import space.kscience.kmath.operations.Norm;
import space.kscience.kmath.operations.NumbersAddOps;
import space.kscience.kmath.operations.PowerOperations;
import space.kscience.kmath.operations.ScaleOperations;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0004\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\u00032\b\u0012\u0004\u0012\u00020\u00020\u00052\b\u0012\u0004\u0012\u00020\u00020\u00062\b\u0012\u0004\u0012\u00020\u00020\u00072\b\u0012\u0004\u0012\u00020\u00020\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u0018\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\u0010\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u0010\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u0018\u0010 \u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\u0010\u0010!\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u0010\u0010\"\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u0018\u0010#\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\u0015\u0010$\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010%J\u0010\u0010&\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020'H\u0016J\u0018\u0010(\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010)\u001a\u00020'H\u0016J\u0018\u0010*\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\u00022\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\u0002H\u0002J\u0010\u0010/\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\u0002H\u0002J\u0010\u00100\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\u0002H\u0002J\u0018\u00101\u001a\u00020\u00022\u0006\u0010,\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u0004H\u0016J\u0010\u00102\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u0010\u00103\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u0015\u00104\u001a\u00020\u0002*\u00020'2\u0006\u00105\u001a\u00020\u0002H\u0096\u0002J\u0015\u00104\u001a\u00020\u0002*\u00020\u00022\u0006\u00105\u001a\u00020'H\u0096\u0002J\u0015\u00106\u001a\u00020\u0002*\u00020'2\u0006\u00105\u001a\u00020\u0002H\u0096\u0002J\u0015\u00106\u001a\u00020\u0002*\u00020\u00022\u0006\u00105\u001a\u00020'H\u0096\u0002J\u0015\u00107\u001a\u00020\u0002*\u00020'2\u0006\u0010\u0016\u001a\u00020\u0002H\u0096\u0002J\r\u00108\u001a\u00020\u0002*\u00020\u0002H\u0096\u0002R\u0011\u0010\n\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0014\u0010\u0011\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0014\u0010\u0013\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\f\u00a8\u00069"}, d2={"Lspace/kscience/kmath/complex/QuaternionField;", "Lspace/kscience/kmath/operations/Field;", "Lspace/kscience/kmath/complex/Quaternion;", "Lspace/kscience/kmath/operations/Norm;", "", "Lspace/kscience/kmath/operations/PowerOperations;", "Lspace/kscience/kmath/operations/ExponentialOperations;", "Lspace/kscience/kmath/operations/NumbersAddOps;", "Lspace/kscience/kmath/operations/ScaleOperations;", "()V", "i", "getI", "()Lspace/kscience/kmath/complex/Quaternion;", "j", "getJ", "k", "getK", "one", "getOne", "zero", "getZero", "acosh", "arg", "add", "left", "right", "asinh", "atanh", "bindSymbolOrNull", "value", "", "cosh", "divide", "exp", "ln", "multiply", "norm", "(Lspace/kscience/kmath/complex/Quaternion;)Ljava/lang/Double;", "number", "", "power", "pow", "pwr", "x", "a", "", "pwr2", "pwr3", "pwr4", "scale", "sinh", "tanh", "minus", "other", "plus", "times", "unaryMinus", "kmath-complex"})
@SourceDebugExtension(value={"SMAP\nQuaternion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Quaternion.kt\nspace/kscience/kmath/complex/QuaternionField\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Algebra.kt\nspace/kscience/kmath/operations/AlgebraKt\n*L\n1#1,296:1\n1#2:297\n123#3:298\n*S KotlinDebug\n*F\n+ 1 Quaternion.kt\nspace/kscience/kmath/complex/QuaternionField\n*L\n235#1:298\n*E\n"})
public final class QuaternionField
implements Field<Quaternion>,
Norm<Quaternion, Double>,
PowerOperations<Quaternion>,
ExponentialOperations<Quaternion>,
NumbersAddOps<Quaternion>,
ScaleOperations<Quaternion> {
    @NotNull
    public static final QuaternionField INSTANCE = new QuaternionField();
    @NotNull
    private static final Quaternion zero = QuaternionKt.Quaternion$default(0.0, null, null, null, 14, null);
    @NotNull
    private static final Quaternion one = QuaternionKt.Quaternion$default(1.0, null, null, null, 14, null);
    @NotNull
    private static final Quaternion i = new Quaternion(0.0, 1.0, 0.0, 0.0);
    @NotNull
    private static final Quaternion j = new Quaternion(0.0, 0.0, 1.0, 0.0);
    @NotNull
    private static final Quaternion k = new Quaternion(0.0, 0.0, 0.0, 1.0);

    private QuaternionField() {
    }

    @NotNull
    public Quaternion getZero() {
        return zero;
    }

    @NotNull
    public Quaternion getOne() {
        return one;
    }

    @NotNull
    public final Quaternion getI() {
        return i;
    }

    @NotNull
    public final Quaternion getJ() {
        return j;
    }

    @NotNull
    public final Quaternion getK() {
        return k;
    }

    @NotNull
    public Quaternion add(@NotNull Quaternion left, @NotNull Quaternion right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return new Quaternion(left.getW() + right.getW(), left.getX() + right.getX(), left.getY() + right.getY(), left.getZ() + right.getZ());
    }

    @NotNull
    public Quaternion scale(@NotNull Quaternion a, double value) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        return new Quaternion(a.getW() * value, a.getX() * value, a.getY() * value, a.getZ() * value);
    }

    @NotNull
    public Quaternion multiply(@NotNull Quaternion left, @NotNull Quaternion right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return new Quaternion(left.getW() * right.getW() - left.getX() * right.getX() - left.getY() * right.getY() - left.getZ() * right.getZ(), left.getW() * right.getX() + left.getX() * right.getW() + left.getY() * right.getZ() - left.getZ() * right.getY(), left.getW() * right.getY() - left.getX() * right.getZ() + left.getY() * right.getW() + left.getZ() * right.getX(), left.getW() * right.getZ() + left.getX() * right.getY() - left.getY() * right.getX() + left.getZ() * right.getW());
    }

    @NotNull
    public Quaternion divide(@NotNull Quaternion left, @NotNull Quaternion right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        double s = right.getW() * right.getW() + right.getX() * right.getX() + right.getY() * right.getY() + right.getZ() * right.getZ();
        return new Quaternion((right.getW() * left.getW() + right.getX() * left.getX() + right.getY() * left.getY() + right.getZ() * left.getZ()) / s, (right.getW() * left.getX() - right.getX() * left.getW() - right.getY() * left.getZ() + right.getZ() * left.getY()) / s, (right.getW() * left.getY() + right.getX() * left.getZ() - right.getY() * left.getW() - right.getZ() * left.getX()) / s, (right.getW() * left.getZ() - right.getX() * left.getY() + right.getY() * left.getX() - right.getZ() * left.getW()) / s);
    }

    @NotNull
    public Quaternion power(@NotNull Quaternion arg, @NotNull Number pow) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        Intrinsics.checkNotNullParameter((Object)pow, (String)"pow");
        if (pow instanceof Integer) {
            return this.pwr(arg, pow.intValue());
        }
        if (Math.floor(pow.doubleValue()) == pow.doubleValue()) {
            return this.pwr(arg, pow.intValue());
        }
        return this.exp(this.times(pow, this.ln(arg)));
    }

    private final Quaternion pwr(Quaternion x, int a) {
        Quaternion quaternion;
        if (a < 0) {
            quaternion = this.unaryMinus(this.pwr(x, -a));
        } else if (a == 0) {
            quaternion = this.getOne();
        } else if (a == 1) {
            quaternion = x;
        } else if (a == 2) {
            quaternion = this.pwr2(x);
        } else if (a == 3) {
            quaternion = this.pwr3(x);
        } else if (a == 4) {
            quaternion = this.pwr4(x);
        } else {
            Quaternion x4 = this.pwr4(x);
            Object y = null;
            y = x4;
            int n = CollectionsKt.count((Iterable)((Iterable)RangesKt.until((int)1, (int)(a / 4))));
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                y = INSTANCE.times(y, x4);
            }
            if (a % 4 == 3) {
                y = this.times(y, this.pwr3(x));
            }
            if (a % 4 == 2) {
                y = this.times(y, this.pwr2(x));
            }
            if (a % 4 == 1) {
                y = this.times(y, x);
            }
            quaternion = (Quaternion)y;
        }
        return quaternion;
    }

    private final Quaternion pwr2(Quaternion x) {
        double aa = (double)2 * x.getW();
        return new Quaternion(x.getW() * x.getW() - (x.getX() * x.getX() + x.getY() * x.getY() + x.getZ() * x.getZ()), aa * x.getX(), aa * x.getY(), aa * x.getZ());
    }

    private final Quaternion pwr3(Quaternion x) {
        double a2 = x.getW() * x.getW();
        double n1 = x.getX() * x.getX() + x.getY() * x.getY() + x.getZ() * x.getZ();
        double n2 = 3.0 * a2 - n1;
        return new Quaternion(x.getW() * (a2 - (double)3 * n1), x.getX() * n2, x.getY() * n2, x.getZ() * n2);
    }

    private final Quaternion pwr4(Quaternion x) {
        double a2 = x.getW() * x.getW();
        double n1 = x.getX() * x.getX() + x.getY() * x.getY() + x.getZ() * x.getZ();
        double n2 = (double)4 * x.getW() * (a2 - n1);
        return new Quaternion(a2 * a2 - (double)6 * a2 * n1 + n1 * n1, x.getX() * n2, x.getY() * n2, x.getZ() * n2);
    }

    @NotNull
    public Quaternion exp(@NotNull Quaternion arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        double un = arg.getX() * arg.getX() + arg.getY() * arg.getY() + arg.getZ() * arg.getZ();
        if (un == 0.0) {
            return QuaternionKt.Quaternion$default(Math.exp(arg.getW()), null, null, null, 14, null);
        }
        double n1 = Math.sqrt(un);
        double ea = Math.exp(arg.getW());
        double n2 = ea * Math.sin(n1) / n1;
        return new Quaternion(ea * Math.cos(n1), n2 * arg.getX(), n2 * arg.getY(), n2 * arg.getZ());
    }

    @NotNull
    public Quaternion ln(@NotNull Quaternion arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        double nu2 = arg.getX() * arg.getX() + arg.getY() * arg.getY() + arg.getZ() * arg.getZ();
        if (nu2 == 0.0) {
            Quaternion quaternion;
            if (arg.getW() > 0.0) {
                quaternion = QuaternionKt.Quaternion(Math.log(arg.getW()), 0, 0, 0);
            } else {
                Algebra $this$invoke$iv = (Algebra)ComplexField.INSTANCE;
                boolean $i$f$invoke = false;
                ComplexField $this$ln_u24lambda_u241 = (ComplexField)$this$invoke$iv;
                boolean bl = false;
                Complex l = $this$ln_u24lambda_u241.ln(ComplexKt.toComplex(arg.getW()));
                quaternion = QuaternionKt.Quaternion(l.getRe(), l.getIm(), 0, 0);
            }
            return quaternion;
        }
        double a = arg.getW();
        if (!(nu2 > 0.0)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        double n = Math.sqrt(a * a + nu2);
        double th = Math.acos(a / n) / Math.sqrt(nu2);
        return new Quaternion(Math.log(n), th * arg.getX(), th * arg.getY(), th * arg.getZ());
    }

    @NotNull
    public Quaternion plus(@NotNull Number $this$plus, @NotNull Quaternion other) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Quaternion($this$plus.doubleValue() + other.getW(), other.getX(), other.getY(), other.getZ());
    }

    @NotNull
    public Quaternion minus(@NotNull Number $this$minus, @NotNull Quaternion other) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Quaternion($this$minus.doubleValue() - other.getW(), -other.getX(), -other.getY(), -other.getZ());
    }

    @NotNull
    public Quaternion plus(@NotNull Quaternion $this$plus, @NotNull Number other) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Quaternion($this$plus.getW() + other.doubleValue(), $this$plus.getX(), $this$plus.getY(), $this$plus.getZ());
    }

    @NotNull
    public Quaternion minus(@NotNull Quaternion $this$minus, @NotNull Number other) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Quaternion($this$minus.getW() - other.doubleValue(), $this$minus.getX(), $this$minus.getY(), $this$minus.getZ());
    }

    @NotNull
    public Quaternion times(@NotNull Number $this$times, @NotNull Quaternion arg) {
        Intrinsics.checkNotNullParameter((Object)$this$times, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        return new Quaternion($this$times.doubleValue() * arg.getW(), $this$times.doubleValue() * arg.getX(), $this$times.doubleValue() * arg.getY(), $this$times.doubleValue() * arg.getZ());
    }

    @NotNull
    public Quaternion unaryMinus(@NotNull Quaternion $this$unaryMinus) {
        Intrinsics.checkNotNullParameter((Object)$this$unaryMinus, (String)"<this>");
        return new Quaternion(-$this$unaryMinus.getW(), -$this$unaryMinus.getX(), -$this$unaryMinus.getY(), -$this$unaryMinus.getZ());
    }

    @NotNull
    public Double norm(@NotNull Quaternion arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        return Math.sqrt(Math.pow(arg.getW(), 2) + Math.pow(arg.getX(), 2) + Math.pow(arg.getY(), 2) + Math.pow(arg.getZ(), 2));
    }

    @Nullable
    public Quaternion bindSymbolOrNull(@NotNull String value) {
        Quaternion quaternion;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        switch (value) {
            case "i": {
                quaternion = i;
                break;
            }
            case "j": {
                quaternion = j;
                break;
            }
            case "k": {
                quaternion = k;
                break;
            }
            default: {
                quaternion = null;
            }
        }
        return quaternion;
    }

    @NotNull
    public Quaternion number(@NotNull Number value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return QuaternionKt.Quaternion$default(value, null, null, null, 14, null);
    }

    @NotNull
    public Quaternion sinh(@NotNull Quaternion arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        return (Quaternion)this.div(this.minus(this.exp(arg), this.exp(this.unaryMinus(arg))), 2.0);
    }

    @NotNull
    public Quaternion cosh(@NotNull Quaternion arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        return (Quaternion)this.div(this.plus(this.exp(arg), this.exp(this.unaryMinus(arg))), 2.0);
    }

    @NotNull
    public Quaternion tanh(@NotNull Quaternion arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        return (Quaternion)this.div(this.minus(this.exp(arg), this.exp(this.unaryMinus(arg))), this.plus(this.exp(this.unaryMinus(arg)), this.exp(arg)));
    }

    @NotNull
    public Quaternion asinh(@NotNull Quaternion arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        return this.ln((Quaternion)this.plus(this.sqrt(this.plus(this.times(arg, arg), this.getOne())), arg));
    }

    @NotNull
    public Quaternion acosh(@NotNull Quaternion arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        return this.ln((Quaternion)this.plus(arg, this.sqrt(this.times(this.minus(arg, this.getOne()), this.plus(arg, this.getOne())))));
    }

    @NotNull
    public Quaternion atanh(@NotNull Quaternion arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        return (Quaternion)this.div(this.minus(this.ln((Quaternion)this.plus(arg, this.getOne())), this.ln((Quaternion)this.minus(this.getOne(), arg))), 2.0);
    }
}

