/*
 * Decompiled with CFR 0.152.
 */
package space.kscience.kmath.domains;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import space.kscience.kmath.UnstableKMathAPI;
import space.kscience.kmath.domains.DoubleDomain;
import space.kscience.kmath.structures.Buffer;
import space.kscience.kmath.structures.BufferKt;
import space.kscience.kmath.structures.DoubleBuffer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J!\u0010\u0012\u001a\u00020\u00132\u0016\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0015H\u0096\u0002J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\fH\u0016J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\fH\u0016J\b\u0010\u0019\u001a\u00020\u0004H\u0016R\u001a\u0010\u0007\u001a\u00020\b8F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001a"}, d2={"Lspace/kscience/kmath/domains/HyperSquareDomain;", "Lspace/kscience/kmath/domains/DoubleDomain;", "lower", "Lspace/kscience/kmath/structures/Buffer;", "", "upper", "(Lspace/kscience/kmath/structures/Buffer;Lspace/kscience/kmath/structures/Buffer;)V", "center", "Lspace/kscience/kmath/structures/DoubleBuffer;", "getCenter-Dv3HvWU", "()[D", "dimension", "", "getDimension", "()I", "getLower", "()Lspace/kscience/kmath/structures/Buffer;", "getUpper", "contains", "", "point", "Lspace/kscience/kmath/linear/Point;", "getLowerBound", "num", "getUpperBound", "volume", "kmath-core"})
@UnstableKMathAPI
@SourceDebugExtension(value={"SMAP\nHyperSquareDomain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HyperSquareDomain.kt\nspace/kscience/kmath/domains/HyperSquareDomain\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 DoubleBuffer.kt\nspace/kscience/kmath/structures/DoubleBufferKt\n*L\n1#1,51:1\n1726#2,3:52\n1726#2,3:56\n45#3:55\n*S KotlinDebug\n*F\n+ 1 HyperSquareDomain.kt\nspace/kscience/kmath/domains/HyperSquareDomain\n*L\n23#1:52,3\n32#1:56,3\n30#1:55\n*E\n"})
public final class HyperSquareDomain
implements DoubleDomain {
    @NotNull
    private final Buffer<Double> lower;
    @NotNull
    private final Buffer<Double> upper;

    public HyperSquareDomain(@NotNull Buffer<Double> lower, @NotNull Buffer<Double> upper) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(lower, (String)"lower");
            Intrinsics.checkNotNullParameter(upper, (String)"upper");
            this.lower = lower;
            this.upper = upper;
            if (!(this.lower.getSize() == this.upper.getSize())) {
                boolean $i$a$-require-HyperSquareDomain$22 = false;
                String $i$a$-require-HyperSquareDomain$22 = "Domain borders size mismatch. Lower borders size is " + this.lower.getSize() + ", but upper borders size is " + this.upper.getSize() + ".";
                throw new IllegalArgumentException($i$a$-require-HyperSquareDomain$22.toString());
            }
            Iterable $this$all$iv = (Iterable)BufferKt.getIndices(this.lower);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    if (((Number)this.lower.get(it)).doubleValue() <= ((Number)this.upper.get(it)).doubleValue()) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (!bl) {
            boolean bl3 = false;
            String string = "Domain borders order mismatch. Lower borders must be less or equals than upper borders.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final Buffer<Double> getLower() {
        return this.lower;
    }

    @NotNull
    public final Buffer<Double> getUpper() {
        return this.upper;
    }

    @Override
    public int getDimension() {
        return this.lower.getSize();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final double[] getCenter-Dv3HvWU() {
        int size$iv = this.getDimension();
        boolean $i$f$DoubleBuffer = false;
        int n = 0;
        double[] dArray = new double[size$iv];
        while (n < size$iv) {
            void it;
            double d;
            int n2;
            int n3 = n2 = n++;
            int n4 = n2;
            double[] dArray2 = dArray;
            boolean bl = false;
            dArray2[n4] = d = (((Number)this.lower.get((int)it)).doubleValue() + ((Number)this.upper.get((int)it)).doubleValue()) / 2.0;
        }
        return DoubleBuffer.constructor-impl(dArray);
    }

    @Override
    public boolean contains(@NotNull Buffer<Double> point) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(point, (String)"point");
            Iterable $this$all$iv = (Iterable)BufferKt.getIndices(point);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int i = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    double d = ((Number)this.lower.get(i)).doubleValue();
                    double d2 = ((Number)this.upper.get(i)).doubleValue();
                    double d3 = ((Number)point.get(i)).doubleValue();
                    if (d <= d3 ? d3 <= d2 : false) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public double getLowerBound(int num) {
        return ((Number)this.lower.get(num)).doubleValue();
    }

    @Override
    public double getUpperBound(int num) {
        return ((Number)this.upper.get(num)).doubleValue();
    }

    @Override
    public double volume() {
        double res = 1.0;
        int n = this.getDimension();
        for (int i = 0; i < n; ++i) {
            if (Double.isInfinite(((Number)this.lower.get(i)).doubleValue()) || Double.isInfinite(((Number)this.upper.get(i)).doubleValue())) {
                return Double.POSITIVE_INFINITY;
            }
            if (!(((Number)this.upper.get(i)).doubleValue() > ((Number)this.lower.get(i)).doubleValue())) continue;
            res *= ((Number)this.upper.get(i)).doubleValue() - ((Number)this.lower.get(i)).doubleValue();
        }
        return res;
    }
}

